// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_COMPONENTS_TETHER_FAKE_WIFI_HOTSPOT_CONNECTOR_H_
#define ASH_COMPONENTS_TETHER_FAKE_WIFI_HOTSPOT_CONNECTOR_H_

#include <string>

#include "ash/components/tether/wifi_hotspot_connector.h"

namespace ash {

namespace tether {

// Test double for WifiHotspotConnector.
class FakeWifiHotspotConnector : public WifiHotspotConnector {
 public:
  FakeWifiHotspotConnector(NetworkStateHandler* network_state_handler);

  FakeWifiHotspotConnector(const FakeWifiHotspotConnector&) = delete;
  FakeWifiHotspotConnector& operator=(const FakeWifiHotspotConnector&) = delete;

  ~FakeWifiHotspotConnector() override;

  // Pass an empty string for |wifi_guid| to signify a failed connection.
  void CallMostRecentCallback(const std::string& wifi_guid);

  std::string most_recent_ssid() { return most_recent_ssid_; }

  std::string most_recent_password() { return most_recent_password_; }

  std::string most_recent_tether_network_guid() {
    return most_recent_tether_network_guid_;
  }

  // WifiHotspotConnector:
  void ConnectToWifiHotspot(
      const std::string& ssid,
      const std::string& password,
      const std::string& tether_network_guid,
      WifiHotspotConnector::WifiConnectionCallback callback) override;

 private:
  std::string most_recent_ssid_;
  std::string most_recent_password_;
  std::string most_recent_tether_network_guid_;
  WifiHotspotConnector::WifiConnectionCallback most_recent_callback_;
};

}  // namespace tether

}  // namespace ash

#endif  // ASH_COMPONENTS_TETHER_FAKE_WIFI_HOTSPOT_CONNECTOR_H_
