// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_METRICS_USER_METRICS_ACTION_H_
#define ASH_METRICS_USER_METRICS_ACTION_H_

namespace ash {

// Ash-owned user metrics.
// DEPRECATED: Use base::RecordAction(base::UserMetricsAction("my_action"))
// instead of adding things here.
enum UserMetricsAction {
  UMA_DESKTOP_SWITCH_TASK,
  UMA_LAUNCHER_BUTTON_PRESSED_WITH_MOUSE,
  UMA_LAUNCHER_BUTTON_PRESSED_WITH_TOUCH,
  UMA_LAUNCHER_CLICK_ON_APP,
  UMA_LAUNCHER_CLICK_ON_APPLIST_BUTTON,
  UMA_LAUNCHER_LAUNCH_TASK,
  UMA_LAUNCHER_MINIMIZE_TASK,
  UMA_LAUNCHER_SWITCH_TASK,
  UMA_SHELF_ALIGNMENT_SET_BOTTOM,
  UMA_SHELF_ALIGNMENT_SET_LEFT,
  UMA_SHELF_ALIGNMENT_SET_RIGHT,
  UMA_SHELF_ITEM_PINNED,
  UMA_SHELF_ITEM_UNPINNED,
  UMA_STATUS_AREA_AUDIO_CURRENT_INPUT_DEVICE,
  UMA_STATUS_AREA_AUDIO_CURRENT_OUTPUT_DEVICE,
  UMA_STATUS_AREA_AUDIO_SWITCH_INPUT_DEVICE,
  UMA_STATUS_AREA_AUDIO_SWITCH_OUTPUT_DEVICE,
  UMA_STATUS_AREA_BRIGHTNESS_CHANGED,
  UMA_STATUS_AREA_BLUETOOTH_DISABLED,
  UMA_STATUS_AREA_BLUETOOTH_ENABLED,
  UMA_STATUS_AREA_CAPS_LOCK_DETAILED,
  UMA_STATUS_AREA_CAPS_LOCK_DISABLED_BY_CLICK,
  UMA_STATUS_AREA_CAPS_LOCK_ENABLED_BY_CLICK,
  UMA_STATUS_AREA_CAPS_LOCK_POPUP,
  UMA_STATUS_AREA_CAST_STOP_CAST,
  UMA_STATUS_AREA_CONNECT_TO_CONFIGURED_NETWORK,
  UMA_STATUS_AREA_CONNECT_TO_UNCONFIGURED_NETWORK,
  UMA_STATUS_AREA_CONNECT_TO_VPN,
  UMA_STATUS_AREA_CHANGED_VOLUME_MENU,
  UMA_STATUS_AREA_CHANGED_VOLUME_POPUP,
  UMA_STATUS_AREA_DETAILED_ACCESSIBILITY,
  UMA_STATUS_AREA_DETAILED_AUDIO_VIEW,
  UMA_STATUS_AREA_DETAILED_BLUETOOTH_VIEW,
  UMA_STATUS_AREA_DETAILED_BRIGHTNESS_VIEW,
  UMA_STATUS_AREA_DETAILED_CAST_VIEW,
  UMA_STATUS_AREA_DETAILED_CAST_VIEW_LAUNCH_CAST,
  UMA_STATUS_AREA_DETAILED_DRIVE_VIEW,
  UMA_STATUS_AREA_DETAILED_NETWORK_VIEW,
  UMA_STATUS_AREA_DETAILED_SMS_VIEW,
  UMA_STATUS_AREA_DETAILED_VPN_VIEW,
  UMA_STATUS_AREA_DISABLE_WIFI,
  UMA_STATUS_AREA_DISPLAY_DEFAULT_SELECTED,
  UMA_STATUS_AREA_DISPLAY_DEFAULT_SHOW_SETTINGS,
  UMA_STATUS_AREA_DISPLAY_NOTIFICATION_CREATED,
  UMA_STATUS_AREA_DISPLAY_NOTIFICATION_SELECTED,
  UMA_STATUS_AREA_DISPLAY_NOTIFICATION_SHOW_SETTINGS,
  UMA_STATUS_AREA_DRIVE_CANCEL_OPERATION,
  UMA_STATUS_AREA_DRIVE_SETTINGS,
  UMA_STATUS_AREA_ENABLE_WIFI,
  UMA_STATUS_AREA_MENU_OPENED,
  UMA_STATUS_AREA_NETWORK_JOIN_OTHER_CLICKED,
  UMA_STATUS_AREA_NETWORK_SETTINGS_OPENED,
  UMA_STATUS_AREA_OS_UPDATE_DEFAULT_SELECTED,
  UMA_STATUS_AREA_SCREEN_CAPTURE_CHANGE_SOURCE,
  UMA_STATUS_AREA_SCREEN_CAPTURE_DEFAULT_STOP,
  UMA_STATUS_AREA_SCREEN_CAPTURE_NOTIFICATION_STOP,
  UMA_STATUS_AREA_SHOW_NETWORK_CONNECTION_DETAILS,
  UMA_STATUS_AREA_SHOW_VPN_CONNECTION_DETAILS,
  UMA_STATUS_AREA_SIGN_OUT,
  UMA_STATUS_AREA_SMS_DETAILED_DISMISS_MSG,
  UMA_STATUS_AREA_SMS_NOTIFICATION_DISMISS_MSG,
  UMA_STATUS_AREA_TRACING_DEFAULT_SELECTED,
  UMA_STATUS_AREA_VPN_ADD_BUILT_IN_CLICKED,
  UMA_STATUS_AREA_VPN_ADD_THIRD_PARTY_CLICKED,
  UMA_STATUS_AREA_VPN_DISCONNECT_CLICKED,
  UMA_STATUS_AREA_VPN_SETTINGS_OPENED,
  UMA_TRAY_HELP,
  UMA_TRAY_LOCK_SCREEN,
  UMA_TRAY_NIGHT_LIGHT,
  UMA_TRAY_OVERVIEW,
  UMA_TRAY_SETTINGS,
  UMA_TRAY_SHUT_DOWN,

  // DEPRECATED: Do not add new values. See top of file.
};

}  // namespace ash

#endif  // ASH_METRICS_USER_METRICS_ACTION_H_
