// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_
#define ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_

#include <memory>
#include <string>

#include "ash/public/cpp/ash_public_export.h"
#include "base/memory/scoped_refptr.h"
#include "ui/gfx/color_palette.h"
#include "ui/message_center/public/cpp/notification.h"
#include "ui/message_center/public/cpp/notification_types.h"
#include "ui/message_center/public/cpp/notifier_id.h"

class GURL;

namespace gfx {
struct VectorIcon;
}

namespace ui {
namespace message_center {
class NotificationDelegate;
}  // namespace message_center
}  // namespace ui

namespace ash {

// Accent colors of system notifications.
constexpr SkColor kSystemNotificationColorNormal = gfx::kGoogleBlue700;
constexpr SkColor kSystemNotificationColorWarning = gfx::kGoogleYellow900;
constexpr SkColor kSystemNotificationColorCriticalWarning = gfx::kGoogleRed700;

// Factory method to create all kinds of notifications generated by system,
// from normal priority ones to critical priority ones.
// |small_image| is a small icon show on the upper left header to illustrate
// |display_source| of the notification.
// One specified in the |optional_fields| is overridden.
ASH_PUBLIC_EXPORT std::unique_ptr<message_center::Notification>
CreateSystemNotification(
    message_center::NotificationType type,
    const std::string& id,
    const std::u16string& title,
    const std::u16string& message,
    const std::u16string& display_source,
    const GURL& origin_url,
    const message_center::NotifierId& notifier_id,
    const message_center::RichNotificationData& optional_fields,
    scoped_refptr<message_center::NotificationDelegate> delegate,
    const gfx::VectorIcon& small_image,
    message_center::SystemNotificationWarningLevel warning_level);

}  // namespace ash

#endif  // ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_
