// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ta_inscript.h"

namespace ta_inscript {

const char* kId = "ta_inscript";
bool kIs102 = false;
const char* kNormal[] = {
    u8"\u0bca",  // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"\u0bf2",  // Equal
    u8"\u0bcc",  // KeyQ
    u8"\u0bc8",  // KeyW
    u8"\u0bbe",  // KeyE
    u8"\u0bc0",  // KeyR
    u8"\u0bc2",  // KeyT
    u8"\u0baa",  // KeyY
    u8"\u0bb9",  // KeyU
    u8"\u0b95",  // KeyI
    u8"\u0ba4",  // KeyO
    u8"\u0b9c",  // KeyP
    u8"\u0b9f",  // BracketLeft
    u8"\u0b9e",  // BracketRight
    u8"\u0b9f",  // Backslash
    u8"\u0bcb",  // KeyA
    u8"\u0bc7",  // KeyS
    u8"\u0bcd",  // KeyD
    u8"\u0bbf",  // KeyF
    u8"\u0bc1",  // KeyG
    u8"\u0baa",  // KeyH
    u8"\u0bb0",  // KeyJ
    u8"\u0b95",  // KeyK
    u8"\u0ba4",  // KeyL
    u8"\u0b9a",  // Semicolon
    u8"\u0b9f",  // Quote
    u8"\u0bc6",  // KeyZ
    u8"\u0b82",  // KeyX
    u8"\u0bae",  // KeyC
    u8"\u0ba8",  // KeyV
    u8"\u0bb5",  // KeyB
    u8"\u0bb2",  // KeyN
    u8"\u0bb8",  // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"\u0baf",  // Slash
    u8"\u0020",  // Space
};
const char* kShift[] = {
    u8"\u0b92",                    // BackQuote
    u8"\u0b95",                    // Digit1
    u8"\u0be8",                    // Digit2
    u8"\u0bcd\u0bb0",              // Digit3
    u8"\u20b9",                    // Digit4
    u8"\u0b9c\u0bcd\u0b9e",        // Digit5
    u8"\u0ba4\u0bcd\u0bb0",        // Digit6
    u8"\u0b95\u0bcd\u0bb7",        // Digit7
    u8"\u0bb6\u0bcd\u0bb0",        // Digit8
    u8"(",                         // Digit9
    u8")",                         // Digit0
    u8"\u0b83",                    // Minus
    u8"",                          // Equal
    u8"\u0b94",                    // KeyQ
    u8"\u0b90",                    // KeyW
    u8"\u0b86",                    // KeyE
    u8"\u0b88",                    // KeyR
    u8"\u0b8a",                    // KeyT
    u8"",                          // KeyY
    u8"\u0b99",                    // KeyU
    u8"",                          // KeyI
    u8"",                          // KeyO
    u8"\u0b9a",                    // KeyP
    u8"",                          // BracketLeft
    u8"",                          // BracketRight
    u8"",                          // Backslash
    u8"\u0b93",                    // KeyA
    u8"\u0b8f",                    // KeyS
    u8"\u0b85",                    // KeyD
    u8"\u0b87",                    // KeyF
    u8"\u0b89",                    // KeyG
    u8"",                          // KeyH
    u8"\u0bb1",                    // KeyJ
    u8"",                          // KeyK
    u8"",                          // KeyL
    u8"",                          // Semicolon
    u8"",                          // Quote
    u8"\u0b8e",                    // KeyZ
    u8"",                          // KeyX
    u8"\u0ba3",                    // KeyC
    u8"\u0ba9",                    // KeyV
    u8"\u0bb4",                    // KeyB
    u8"\u0bb3",                    // KeyN
    u8"\u0bb6",                    // KeyM
    u8"\u0bb7",                    // Comma
    u8"\u0bb8\u0bcd\u0bb0\u0bc0",  // Period
    u8"?",                         // Slash
    u8"\u0020",                    // Space
};
const char* kAltGr[] = {
    u8"",        // BackQuote
    u8"\u0be7",  // Digit1
    u8"\u0be8",  // Digit2
    u8"\u0be9",  // Digit3
    u8"\u0bea",  // Digit4
    u8"\u0beb",  // Digit5
    u8"\u0bec",  // Digit6
    u8"\u0bed",  // Digit7
    u8"\u0bee",  // Digit8
    u8"\u0bef",  // Digit9
    u8"\u0be6",  // Digit0
    u8"",        // Minus
    u8"\u0bf2",  // Equal
    u8"",        // KeyQ
    u8"",        // KeyW
    u8"",        // KeyE
    u8"",        // KeyR
    u8"",        // KeyT
    u8"",        // KeyY
    u8"",        // KeyU
    u8"",        // KeyI
    u8"",        // KeyO
    u8"",        // KeyP
    u8"",        // BracketLeft
    u8"",        // BracketRight
    u8"",        // Backslash
    u8"",        // KeyA
    u8"",        // KeyS
    u8"",        // KeyD
    u8"",        // KeyF
    u8"",        // KeyG
    u8"",        // KeyH
    u8"",        // KeyJ
    u8"",        // KeyK
    u8"",        // KeyL
    u8"",        // Semicolon
    u8"",        // Quote
    u8"",        // KeyZ
    u8"",        // KeyX
    u8"",        // KeyC
    u8"",        // KeyV
    u8"",        // KeyB
    u8"",        // KeyN
    u8"",        // KeyM
    u8"",        // Comma
    u8"",        // Period
    u8"",        // Slash
    u8"\u0020",  // Space
};
const char* kCapslock[] = {
    u8"\u0bca",  // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"\u0bf2",  // Equal
    u8"\u0bcc",  // KeyQ
    u8"\u0bc8",  // KeyW
    u8"\u0bbe",  // KeyE
    u8"\u0bc0",  // KeyR
    u8"\u0bc2",  // KeyT
    u8"\u0baa",  // KeyY
    u8"\u0bb9",  // KeyU
    u8"\u0b95",  // KeyI
    u8"\u0ba4",  // KeyO
    u8"\u0b9c",  // KeyP
    u8"\u0b9f",  // BracketLeft
    u8"\u0b9e",  // BracketRight
    u8"\u0b9f",  // Backslash
    u8"\u0bcb",  // KeyA
    u8"\u0bc7",  // KeyS
    u8"\u0bcd",  // KeyD
    u8"\u0bbf",  // KeyF
    u8"\u0bc1",  // KeyG
    u8"\u0baa",  // KeyH
    u8"\u0bb0",  // KeyJ
    u8"\u0b95",  // KeyK
    u8"\u0ba4",  // KeyL
    u8"\u0b9a",  // Semicolon
    u8"\u0b9f",  // Quote
    u8"\u0bc6",  // KeyZ
    u8"\u0b82",  // KeyX
    u8"\u0bae",  // KeyC
    u8"\u0ba8",  // KeyV
    u8"\u0bb5",  // KeyB
    u8"\u0bb2",  // KeyN
    u8"\u0bb8",  // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"\u0baf",  // Slash
    u8"\u0020",  // Space
};
const char* kShiftCapslock[] = {
    u8"\u0b92",                    // BackQuote
    u8"\u0b95",                    // Digit1
    u8"\u0be8",                    // Digit2
    u8"\u0bcd\u0bb0",              // Digit3
    u8"\u20b9",                    // Digit4
    u8"\u0b9c\u0bcd\u0b9e",        // Digit5
    u8"\u0ba4\u0bcd\u0bb0",        // Digit6
    u8"\u0b95\u0bcd\u0bb7",        // Digit7
    u8"\u0bb6\u0bcd\u0bb0",        // Digit8
    u8"(",                         // Digit9
    u8")",                         // Digit0
    u8"\u0b83",                    // Minus
    u8"",                          // Equal
    u8"\u0b94",                    // KeyQ
    u8"\u0b90",                    // KeyW
    u8"\u0b86",                    // KeyE
    u8"\u0b88",                    // KeyR
    u8"\u0b8a",                    // KeyT
    u8"",                          // KeyY
    u8"\u0b99",                    // KeyU
    u8"",                          // KeyI
    u8"",                          // KeyO
    u8"\u0b9a",                    // KeyP
    u8"",                          // BracketLeft
    u8"",                          // BracketRight
    u8"",                          // Backslash
    u8"\u0b93",                    // KeyA
    u8"\u0b8f",                    // KeyS
    u8"\u0b85",                    // KeyD
    u8"\u0b87",                    // KeyF
    u8"\u0b89",                    // KeyG
    u8"",                          // KeyH
    u8"\u0bb1",                    // KeyJ
    u8"",                          // KeyK
    u8"",                          // KeyL
    u8"",                          // Semicolon
    u8"",                          // Quote
    u8"\u0b8e",                    // KeyZ
    u8"",                          // KeyX
    u8"\u0ba3",                    // KeyC
    u8"\u0ba9",                    // KeyV
    u8"\u0bb4",                    // KeyB
    u8"\u0bb3",                    // KeyN
    u8"\u0bb6",                    // KeyM
    u8"\u0bb7",                    // Comma
    u8"\u0bb8\u0bcd\u0bb0\u0bc0",  // Period
    u8"?",                         // Slash
    u8"\u0020",                    // Space
};
const char** kKeyMap[8] = {kNormal,   kShift,         kAltGr, kAltGr,
                           kCapslock, kShiftCapslock, kAltGr, kShiftCapslock};

}  // namespace ta_inscript
