// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "base/cxx17_backports.h"

namespace ash {

extern const float kAccelerometerLaptopModeTestData[] = {
    -0.166016f,   -0.00488281f,  0.924805f,     -0.770508f,    -0.0488281f,
    -0.510742f,   -0.199219f,    -0.0078125f,   0.953125f,     -0.782227f,
    -0.0244141f,  -0.652344f,    -0.177734f,    -0.0136719f,   0.936523f,
    -0.772461f,   -0.0527344f,   -0.59375f,     -0.176758f,    -0.00878906f,
    0.9375f,      -0.777344f,    -0.0419922f,   -0.637695f,    -0.165039f,
    -0.00878906f, 0.942383f,     -0.782227f,    -0.046875f,    -0.613281f,
    -0.180664f,   -0.00976562f,  0.943359f,     -0.777344f,    -0.0419922f,
    -0.601562f,   -0.189453f,    -0.00488281f,  0.943359f,     -0.776367f,
    -0.0263672f,  -0.613281f,    -0.166992f,    -0.00488281f,  0.935547f,
    -0.78125f,    -0.0380859f,   -0.609375f,    -0.176758f,    -0.00878906f,
    0.947266f,    -0.790039f,    -0.0576172f,   -0.585938f,    -0.173828f,
    -0.0126953f,  0.93457f,      -0.780273f,    -0.0654297f,   -0.666016f,
    -0.169922f,   -0.00195312f,  0.928711f,     -0.775391f,    -0.0351562f,
    -0.561523f,   -0.193359f,    0.0f,          0.941406f,     -0.795898f,
    -0.0478516f,  -0.640625f,    -0.162109f,    -0.00585938f,  0.917969f,
    -0.768555f,   -0.0146484f,   -0.685547f,    -0.166992f,    -0.0136719f,
    0.921875f,    -0.755859f,    -0.0166016f,   -0.425781f,    -0.175781f,
    -0.0810547f,  1.00098f,      -0.802734f,    -0.117188f,    -0.585938f,
    -0.210938f,   0.0214844f,    0.881836f,     -0.750977f,    -0.0302734f,
    -0.677734f,   -0.285156f,    0.00976562f,   0.967773f,     -0.763672f,
    -0.0283203f,  -0.850586f,    -0.222656f,    -0.0136719f,   0.943359f,
    -0.763672f,   -0.0507812f,   -0.640625f,    -0.236328f,    0.0859375f,
    0.892578f,    -0.742188f,    0.0302734f,    -0.484375f,    -0.269531f,
    0.0263672f,   0.913086f,     -0.714844f,    -0.00585938f,  -0.745117f,
    -0.275391f,   0.0927734f,    0.977539f,     -0.776367f,    -0.078125f,
    -0.750977f,   -0.155273f,    -0.0341797f,   1.2334f,       -1.06445f,
    -0.0478516f,  -0.823242f,    -0.196289f,    0.046875f,     1.19141f,
    -1.00391f,    -0.140625f,    -0.541016f,    0.0917969f,    0.21582f,
    0.717773f,    -0.764648f,    -0.0341797f,   -0.607422f,    -0.0351562f,
    0.0888672f,   0.207031f,     -0.214844f,    -0.18457f,     -0.0664062f,
    -0.0898438f,  0.0556641f,    0.418945f,     -0.232422f,    0.43457f,
    0.0361328f,   0.143555f,     0.376953f,     1.23633f,      -1.09082f,
    0.529297f,    0.0507812f,    0.205078f,     0.438477f,     1.66602f,
    -1.59668f,    0.325195f,     -1.20996f,     -0.0791016f,   0.404297f,
    1.50977f,     -1.40918f,     0.31543f,      -1.30273f,     -0.0654297f,
    0.141602f,    0.699219f,     -0.589844f,    0.0732422f,    -0.27832f,
    0.00488281f,  0.00683594f,   0.0566406f,    -0.0410156f,   -0.0292969f,
    -0.0234375f,  -0.0488281f,   -0.00195312f,  -0.0292969f,   0.0849609f,
    -0.139648f,   0.0585938f,    0.677734f,     0.667969f,     1.36523f,
    -1.11816f,    0.412109f,     0.844727f,     0.142578f,     0.790039f,
    1.73145f,     -1.68066f,     0.464844f,     -1.29492f,     -0.0800781f,
    0.803711f,    0.879883f,     -0.765625f,    -0.0400391f,   -0.616211f,
    -0.170898f,   0.879883f,     0.510742f,     0.158203f,     0.381836f,
    -0.270508f,   -0.0693359f,   0.651367f,     0.431641f,     0.104492f,
    0.991211f,    -0.0634766f,   -0.0478516f,   0.750977f,     0.283203f,
    -0.0332031f,  1.52051f,      -0.00195312f,  -0.201172f,    1.08984f,
    0.173828f,    0.0849609f,    1.44141f,      -0.214844f,    -0.0107422f,
    1.29785f,     0.520508f,     0.00488281f,   1.73047f,      -0.523438f,
    0.136719f,    1.42188f,      0.987305f,     0.0527344f,    1.74707f,
    -0.525391f,   0.34668f,      0.469727f,     0.428711f,     0.114258f,
    -0.788086f,   0.177734f,     0.400391f,     -0.106445f,    0.328125f,
    -0.566406f,   -0.948242f,    0.670898f,     0.467773f,     -0.21875f,
    0.55957f,     -0.767578f,    -0.232422f,    0.195312f,     0.625f,
    -0.271484f,   0.865234f,     -0.765625f,    0.299805f,     0.0703125f,
    0.378906f,    -0.526367f,    0.548828f,     -0.231445f,    -0.569336f,
    0.455078f,    0.303711f,     -0.866211f,    -0.485352f,    0.566406f,
    -1.60547f,    0.481445f,     0.183594f,     -0.782227f,    -0.260742f,
    0.243164f,    -1.41504f,     0.373047f,     0.172852f,     -0.935547f,
    -0.412109f,   0.133789f,     -1.69727f,     0.178711f,     0.407227f,
    -0.952148f,   -0.227539f,    0.0751953f,    -1.67188f,     0.339844f,
    0.498047f,    -0.795898f,    0.209961f,     0.177734f,     -1.3916f,
    0.458984f,    0.295898f,     0.0390625f,    0.697266f,     0.258789f,
    -0.0703125f,  -0.131836f,    0.56543f,      0.250977f,     0.913086f,
    -0.353516f,   0.90332f,      0.191406f,     0.708008f,     0.352539f,
    0.853516f,    -0.839844f,    0.955078f,     0.636719f,     0.657227f,
    0.389648f,    0.620117f,     -0.725586f,    0.43457f,      0.485352f,
    0.424805f,    0.479492f,     0.287109f,     -0.505859f,    -0.209961f,
    0.0927734f,   0.21582f,      0.709961f,     0.492188f,     -0.413086f,
    -0.0869141f,  0.0673828f,    -0.119141f,    1.20508f,      0.392578f,
    0.229492f,    0.927734f,     -0.297852f,    0.142578f,     1.0293f,
    0.430664f,    0.0449219f,    1.71875f,      -0.0283203f,   0.0107422f,
    1.18164f,     0.0517578f,    0.0751953f,    1.80273f,      -0.0693359f,
    -0.19043f,    1.1748f,       0.236328f,     0.0839844f,    1.78711f,
    -0.472656f,   -0.270508f,    1.10254f,      0.964844f,     0.118164f,
    1.75684f,     -0.901367f,    -0.211914f,    1.11133f,      0.65625f,
    0.308594f,    0.142578f,     0.396484f,     0.239258f,     0.0800781f,
    0.973633f,    -0.824219f,    -0.25293f,     0.485352f,     0.351562f,
    -0.0771484f,  1.08984f,      -0.632812f,    0.240234f,     -0.258789f,
    0.436523f,    -0.514648f,    0.491211f,     0.0664062f,    -0.244141f,
    -0.148438f,   -0.171875f,    -0.477539f,    -0.459961f,    1.1084f,
    -0.822266f,   -0.114258f,    -0.192383f,    -0.608398f,    -0.771484f,
    1.11133f,     -1.25488f,     1.01953f,      -0.0839844f,   -0.620117f,
    -0.794922f,   0.660156f,     -0.876953f,    0.0957031f,    -0.242188f,
    -0.711914f,   -0.55957f,     0.736328f,     -0.649414f,    -0.0263672f,
    -0.258789f,   -0.498047f,    -0.973633f,    0.957031f,     -0.660156f,
    0.186523f,    -0.262695f,    -0.595703f,    -0.787109f,    0.893555f,
    -0.429688f,   -0.0234375f,   -0.254883f,    -0.449219f,    -0.783203f,
    0.90918f,     0.106445f,     -0.161133f,    -0.287109f,    -0.0800781f,
    -0.729492f,   0.933594f,     -0.126953f,    -0.0742188f,   -0.550781f,
    -0.271484f,   -0.989258f,    1.00098f,      -0.879883f,    0.0234375f,
    -0.543945f,   -0.50293f,     -1.18945f,     1.24023f,      -1.33398f,
    0.325195f,    -0.262695f,    -0.307617f,    -0.912109f,    1.39062f,
    -1.06055f,    0.0107422f,    -0.00292969f,  -0.573242f,    -0.4375f,
    1.15625f,     -0.651367f,    -0.310547f,    0.188477f,     -0.730469f,
    -0.121094f,   0.611328f,     -0.779297f,    0.335938f,     0.731445f,
    -0.475586f,   -0.00390625f,  0.100586f,     -0.693359f,    0.254883f,
    0.813477f,    -0.345703f,    0.420898f,     -0.400391f,    -0.539062f,
    0.365234f,    0.720703f,     0.0214844f,    0.673828f,     -0.370117f,
    0.0585938f,   0.499023f,     0.523438f,     0.198242f,     0.759766f,
    -0.544922f,   0.543945f,     0.226562f,     0.473633f,     0.34082f,
    0.595703f,    -0.682617f,    0.292969f,     -0.217773f,    0.0742188f,
    0.553711f,    0.762695f,     -0.504883f,    0.292969f,     0.0751953f,
    0.0126953f,   0.427734f,     0.769531f,     -0.265625f,    0.552734f,
    -0.0175781f,  -0.30957f,     0.253906f,     0.322266f,     0.117188f,
    0.263672f,    -0.706055f,    -0.991211f,    0.266602f,     0.501953f,
    0.00585938f,  0.0341797f,    -1.24805f,     -1.21777f,     0.488281f,
    0.461914f,    0.0986328f,    0.362305f,     -1.1709f,      -1.17188f,
    0.50293f,     0.458984f,     0.108398f,     0.460938f,     -1.52148f,
    -1.27051f,    0.379883f,     0.90625f,      0.0400391f,    0.524414f,
    -1.77832f,    -0.951172f,    0.397461f,     0.589844f,     0.520508f,
    0.439453f,    -1.99902f,     -0.643555f,    0.313477f,     0.766602f,
    0.450195f,    0.286133f,     -1.29883f,     -0.375f,       0.225586f,
    0.697266f,    0.299805f,     0.108398f,     -0.976562f,    0.09375f,
    0.0361328f,   0.851562f,     -0.210938f,    0.0615234f,    -0.0898438f,
    0.59082f,     0.313477f,     0.756836f,     -0.731445f,    0.296875f,
    -0.0927734f,  0.552734f,     0.223633f,     0.558594f,     -0.806641f,
    0.00195312f,  0.03125f,      0.728516f,     0.276367f,     0.744141f,
    -0.994141f,   0.197266f,     -0.425781f,    0.316406f,     0.046875f,
    0.601562f,    -0.633789f,    -0.0576172f,   -0.320312f,    0.786133f,
    0.0986328f,   1.0f,          -1.19922f,     0.34668f,      -0.546875f,
    0.481445f,    0.00390625f,   0.876953f,     -1.04297f,     -0.0507812f,
    -0.775391f,   0.333984f,     -0.0175781f,   1.02539f,      -1.07129f,
    -0.12207f,    -0.212891f,    0.28125f,      0.00488281f,   0.998047f,
    -0.97168f,    0.178711f,     -0.444336f,    0.178711f,     0.0136719f,
    0.896484f,    -0.9375f,      0.0117188f,    -0.291992f,    0.132812f,
    0.0234375f,   0.975586f,     -0.943359f,    -0.0078125f,   0.0546875f,
    0.244141f,    -0.0771484f,   1.05469f,      -1.02148f,     0.313477f,
    -0.349609f,   0.148438f,     0.0839844f,    0.619141f,     -0.75f,
    -0.589844f,   -0.0488281f,   0.0263672f,    -0.176758f,    0.697266f,
    -0.691406f,   -0.625977f,    -0.417969f,    0.408203f,     0.265625f,
    1.01953f,     -1.09863f,     0.106445f,     0.0117188f,    0.157227f,
    0.424805f,    1.07422f,      -0.816406f,    0.498047f,     0.0996094f,
    0.00585938f,  0.53418f,      0.771484f,     -0.610352f,    0.744141f,
    0.0195312f,   0.0478516f,    0.552734f,     0.734375f,     -0.72168f,
    0.518555f,    -0.144531f,    -0.0361328f,   0.513672f,     0.822266f,
    -0.736328f,   0.65918f,      -0.179688f,    -0.104492f,    0.425781f,
    1.00098f,     -0.885742f,    0.739258f,     -0.681641f,    -0.443359f,
    0.375977f,    0.884766f,     -0.724609f,    0.110352f,     -0.289062f,
    -0.414062f,   0.494141f,     0.53125f,      -0.422852f,    0.216797f,
    -0.786133f,   -0.569336f,    0.749023f,     0.75293f,      -0.529297f,
    0.730469f,    -0.911133f,    -0.68457f,     0.611328f,     0.959961f,
    -0.623047f,   1.06543f,      -0.499023f,    -0.392578f,    0.761719f,
    0.43457f,     -0.357422f,    0.631836f,     -0.746094f,    -0.370117f,
    0.777344f,    0.379883f,     -0.225586f,    0.677734f,     -0.478516f,
    -0.358398f,   0.788086f,     0.569336f,     -0.34082f,     0.939453f,
    -0.238281f,   -0.230469f,    0.861328f,     0.448242f,     -0.219727f,
    0.966797f,    -0.310547f,    -0.242188f,    0.863281f,     0.369141f,
    -0.0859375f,  0.87207f,      -0.400391f,    -0.385742f,    0.841797f,
    0.401367f,    -0.0634766f,   0.912109f,     -0.458008f,    0.0107422f,
    0.753906f,    0.758789f,     -0.675781f,    0.765625f,     -0.342773f,
    -0.123047f,   0.855469f,     0.599609f,     -0.490234f,    0.963867f,
    -0.118164f,   -0.0117188f,   0.889648f,     0.637695f,     -0.607422f,
    0.803711f,    -0.597656f,    -0.242188f,    0.855469f,     0.550781f,
    -0.607422f,   0.576172f,     -0.759766f,    -0.220703f,    0.832031f,
    0.477539f,    -0.491211f,    0.470703f,     -0.575195f,    -0.0869141f,
    1.01074f,     0.371094f,     -0.25293f,     0.678711f,     -0.316406f,
    -0.197266f,   1.04785f,      0.386719f,     -0.046875f,    0.967773f,
    -0.761719f,   -0.282227f,    0.956055f,     0.270508f,     0.230469f,
    1.39746f,     -0.864258f,    -0.417969f,    0.761719f,     0.457031f,
    0.0263672f,   1.38379f,      -0.714844f,    -0.288086f,    0.535156f,
    0.689453f,    -0.507812f,    0.68457f,      -0.433594f,    -0.0908203f,
    0.210938f,    0.825195f,     -0.649414f,    0.326172f,     -0.793945f,
    0.0527344f,   0.0546875f,    0.911133f,     -0.616211f,    -0.0214844f,
    -0.00195312f, -0.229492f,    -0.0253906f,   0.775391f,     -0.611328f,
    -0.360352f,   0.0371094f,    0.161133f,     0.0253906f,    0.625f,
    -0.624023f,   -0.344727f,    -0.146484f,    0.371094f,     0.255859f,
    1.41797f,     -1.27832f,     0.614258f,     0.764648f,     0.869141f,
    0.426758f,    0.758789f,     -1.04395f,     0.401367f,     0.263672f,
    0.563477f,    0.450195f,     0.774414f,     -0.908203f,    0.384766f,
    -0.262695f,   0.664062f,     0.509766f,     0.798828f,     -0.757812f,
    0.770508f,    0.491211f,     0.62207f,      0.487305f,     0.496094f,
    -0.530273f,   0.375977f,     1.18652f,      0.736328f,     0.386719f,
    0.470703f,    -0.647461f,    0.379883f,     0.47168f,      0.834961f,
    0.289062f,    0.475586f,     -0.654297f,    0.448242f,     0.395508f,
    0.930664f,    0.0830078f,    0.157227f,     -0.304688f,    0.0634766f,
    1.30078f,     0.905273f,     -0.102539f,    0.0576172f,    -0.303711f,
    -0.334961f,   0.885742f,     0.709961f,     -0.143555f,    0.0390625f,
    -0.18457f,    -0.498047f,    1.1084f,       0.744141f,     0.0283203f,
    0.383789f,    -0.371094f,    -0.126953f,    1.17285f,      0.506836f,
    0.109375f,    0.680664f,     -0.244141f,    -0.0830078f,   0.577148f,
    0.12793f,     0.25f,         0.972656f,     -0.328125f,    0.34082f,
    -0.234375f,   -0.327148f,    0.470703f,     0.987305f,     -0.535156f,
    0.730469f,    -0.957031f,    -0.509766f,    0.602539f,     0.938477f,
    -0.640625f,   0.836914f,     -1.13672f,     -0.56543f,     0.450195f,
    0.737305f,    -0.449219f,    0.649414f,     -1.08105f,     -0.364258f,
    0.338867f,    0.667969f,     -0.533203f,    0.654297f,     -1.0918f,
    -0.505859f,   0.422852f,     0.745117f,     -0.443359f,    0.319336f,
    -0.753906f,   -0.563477f,    0.374023f,     0.640625f,     -0.435547f,
    0.220703f,    -0.868164f,    -0.701172f,    0.317383f,     0.702148f,
    -0.527344f,   0.138672f,     -0.848633f,    -0.431641f,    0.220703f,
    0.329102f,    -0.25293f,     -0.232422f,    -0.875977f,    -0.442383f,
    0.550781f,    0.783203f,     -0.441406f,    0.160156f,     -0.107422f,
    0.0683594f,   0.317383f,     1.12012f,      -1.02344f,     0.322266f,
    -0.469727f,   -0.151367f,    0.43457f,      0.65625f,      -0.745117f,
    0.216797f,    -1.03223f,     -0.200195f,    0.240234f,     1.11035f,
    -0.90332f,    0.239258f,     0.0429688f,    -0.228516f,    0.00390625f,
    0.836914f,    -0.770508f,    -0.280273f,    -0.18457f,     0.0117188f,
    0.214844f,    0.767578f,     -0.774414f,    -0.0703125f,   -0.954102f,
    -0.508789f,   -0.046875f,    1.00391f,      -0.930664f,    0.0292969f,
    0.407227f,    -0.519531f,    0.0361328f,    0.753906f,     -0.777344f,
    -0.0214844f,  0.741211f,     -0.27832f,     -0.0332031f,   1.15625f,
    -0.862305f,   -0.115234f,    0.821289f,     -0.598633f,    0.00488281f,
    0.929688f,    -1.01172f,     -0.0996094f,   0.351562f,     -0.524414f,
    0.118164f,    1.1709f,       -0.938477f,    0.00878906f,   0.948242f,
    -0.475586f,   0.443359f,     0.893555f,     -0.597656f,    0.0107422f,
    0.558594f,    -0.87207f,     0.0810547f,    0.487305f,     -0.808594f,
    0.212891f,    0.0878906f,    -0.612305f,    0.263672f,     0.400391f,
    -0.709961f,   0.380859f,     -0.0839844f,   -0.566406f,    0.466797f,
    0.445312f,    -0.769531f,    0.636719f,     -0.273438f,    -0.648438f,
    0.34375f,     0.56543f,      -0.829102f,    0.417969f,     -0.272461f,
    -0.746094f,   0.202148f,     0.421875f,     -0.445312f,    0.229492f,
    0.178711f,    -0.408203f,    0.477539f,     0.693359f,     -0.675781f,
    0.145508f,    0.37207f,      -0.576172f,    0.0449219f,    0.845703f,
    -0.920898f,   -0.0185547f,   0.487305f,     -0.460938f,    0.0253906f,
    1.04785f,     -0.87207f,     0.176758f,     0.356445f,     -0.217773f,
    0.0332031f,   0.945312f,     -0.556641f,    -0.110352f,    0.725586f,
    0.0810547f,   -0.0361328f,   1.11426f,      -0.396484f,    0.00488281f,
    0.743164f,    0.27832f,      0.0175781f,    0.839844f,     -0.0371094f,
    -0.00878906f, 0.964844f,     0.547852f,     0.0224609f,    0.518555f,
    0.386719f,    -0.0585938f,   1.11816f,      0.712891f,     0.19043f,
    0.523438f,    0.429688f,     -0.179688f,    1.18164f,      0.40332f,
    0.241211f,    1.19043f,      -0.0234375f,   0.119141f,     0.90918f,
    -0.078125f,   0.250977f,     0.973633f,     -0.277344f,    0.227539f,
    0.908203f,    -0.232422f,    0.269531f,     0.807617f,     -0.59668f,
    0.253906f,    0.398438f,     -0.506836f,    0.255859f,     0.694336f,
    -0.742188f,   0.345703f,     0.412109f,     -0.576172f,    0.189453f,
    0.708984f,    -0.808594f,    0.230469f,     0.242188f,     -0.550781f,
    0.0693359f,   0.695312f,     -0.856445f,    -0.0253906f,   0.177734f,
    -0.6875f,     -0.00976562f,  0.731445f,     -0.991211f,    -0.03125f,
    0.0175781f,   -0.805664f,    -0.192383f,    0.827148f,     -0.947266f,
    0.0820312f,   0.254883f,     -0.504883f,    -0.259766f,    0.87207f,
    -0.693359f,   -0.345703f,    0.639648f,     -0.162109f,    -0.443359f,
    1.05176f,     -0.595703f,    -0.496094f,    0.485352f,     -0.0380859f,
    -0.490234f,   0.763672f,     -0.382812f,    -0.634766f,    0.369141f,
    0.136719f,    -0.650391f,    0.536133f,     -0.126953f,    -0.901367f,
    0.275391f,    0.155273f,     -0.75293f,     0.476562f,     -0.183594f,
    -1.00488f,    0.206055f,     -0.0908203f,   -1.06836f,     0.3125f,
    -0.183594f,   -1.30762f,     0.37793f,      -0.185547f,    -0.885742f,
    0.496094f,    -0.250977f,    -1.14941f,     0.0517578f,    -0.242188f,
    -0.753906f,   0.395508f,     -0.133789f,    -1.10156f,     0.183594f,
    -0.398438f,   -0.767578f,    0.951172f,     -0.359375f,    -0.866211f,
    0.373047f,    -0.0224609f,   -0.0537109f,   0.921875f,     -0.263672f,
    -0.251953f,   0.455078f,     0.230469f,     0.485352f,     0.84082f,
    0.0351562f,   0.0810547f,    0.554688f,     0.186523f,     0.774414f,
    0.720703f,    0.381836f,     0.71875f,      0.495117f,     0.530273f,
    0.771484f,    0.90332f,      0.34668f,      0.897461f,     0.456055f,
    0.575195f,    0.560547f,     0.133789f,     0.62793f,      0.795898f,
    0.400391f,    0.594727f,     0.577148f,     -0.142578f,    0.691406f,
    0.770508f,    0.12793f,      0.679688f,     0.751953f,     -0.201172f,
    0.728516f,    0.805664f,     -0.0175781f,   0.46875f,      0.655273f,
    -0.608398f,   0.750977f,     0.540039f,     -0.0166016f,   0.30957f,
    0.755859f,    -0.563477f,    0.609375f,     0.763672f,     -0.310547f,
    0.0791016f,   0.668945f,     -0.575195f,    0.398438f,     0.767578f,
    -0.47168f,    -0.12793f,     0.631836f,     -0.768555f,    0.293945f,
    0.760742f,    -0.743164f,    -0.311523f,    0.509766f,     -0.755859f,
    0.15918f,     0.614258f,     -0.832031f,    -0.575195f,    0.448242f,
    -0.771484f,   -0.0605469f,   0.341797f,     -0.652344f,    -0.8125f,
    0.262695f,    -0.205078f,    -0.541992f,    0.337891f,     -0.8125f,
    -1.20996f,    0.179688f,     -0.311523f,    -0.682617f,    0.0556641f,
    -0.944336f,   -1.29102f,     0.09375f,      0.503906f,     -0.87793f,
    -0.0742188f,  -0.805664f,    -1.53613f,     -0.107422f,    0.50293f,
    -0.807617f,   -0.423828f,    0.0888672f,    -0.847656f,    -0.342773f,
    0.719727f,    -0.87793f,     -0.336914f,    0.115234f,     -0.500977f,
    -0.487305f,   0.395508f,     -0.398438f,    -0.624023f,    0.3125f,
    -0.0693359f,  -0.605469f,    0.429688f,     -0.283203f,    -0.813477f,
    0.246094f,    0.0898438f,    -0.764648f,    0.356445f,     -0.106445f,
    -1.05371f,    0.595703f,     0.251953f,     -0.729492f,    0.336914f,
    -0.0595703f,  -1.06445f,     0.824219f,     0.320312f,     -0.50293f,
    0.459961f,    -0.161133f,    -0.820312f,    0.516602f,     0.410156f,
    -0.401367f,   0.407227f,     -0.106445f,    -0.740234f,    0.546875f,
    0.663086f,    -0.170898f,    0.574219f,     -0.419922f,    -0.271484f,
    -0.0273438f,  0.239258f,     -0.0361328f,   0.80957f,      -0.576172f,
    0.0664062f,   0.0332031f,    0.181641f,     0.245117f,     1.06641f,
    -0.826172f,   0.30957f,      -0.241211f,    0.03125f,      0.422852f,
    1.14648f,     -0.916992f,    0.672852f,     -0.242188f,    0.0234375f,
    0.425781f,    1.16895f,      -1.08887f,     0.748047f,     -0.384766f,
    0.102539f,    0.457031f,     0.992188f,     -0.896484f,    0.65625f,
    -0.144531f,   0.0332031f,    0.295898f,     0.8125f,       -0.706055f,
    0.166016f,    -0.237305f,    0.0996094f,    0.130859f,     0.723633f,
    -0.769531f,   -0.125f,       -0.339844f,    -0.277344f,    -0.00390625f,
    1.2959f,      -0.999023f,    0.0185547f,    0.0527344f,    0.270508f,
    0.104492f,    1.05469f,      -1.0918f,      0.205078f,     0.00390625f,
    0.141602f,    0.000976562f,  1.15039f,      -1.14844f,     0.0664062f,
    -0.0566406f,  0.0732422f,    0.0302734f,    1.08398f,      -1.04004f,
    0.124023f,    -0.114258f,    0.19043f,      0.0263672f,    0.985352f,
    -1.00293f,    0.0634766f,    -0.0585938f,   0.257812f,     -0.0527344f,
    0.96875f,     -0.990234f,    -0.0361328f,   -0.179688f,    0.266602f,
    -0.219727f,   0.882812f,     -0.879883f,    -0.289062f,    -0.00292969f,
    0.351562f,    -0.313477f,    0.826172f,     -0.84668f,     -0.322266f,
    0.337891f,    0.478516f,     -0.426758f,    0.594727f,     -0.621094f,
    -0.435547f,   0.676758f,     0.47168f,      -0.432617f,    0.333008f,
    -0.338867f,   -0.767578f,    0.419922f,     0.576172f,     -0.673828f,
    0.321289f,    -0.53125f,     -0.96582f,     0.290039f,     0.426758f,
    -0.526367f,   0.230469f,     -0.508789f,    -1.05859f,     0.195312f,
    0.493164f,    -0.479492f,    0.78418f,      -0.992188f,    -0.453125f,
    -0.185547f,   0.375977f,     -0.291992f,    0.77832f,      -0.884766f,
    -0.361328f,   0.438477f,     -0.118164f,    -0.222656f,    0.923828f,
    -0.796875f,   0.0234375f,    -0.375f,       0.0332031f,    -0.216797f,
    0.908203f,    -0.984375f,    -0.295898f,    -0.384766f,    0.0234375f,
    -0.305664f,   1.12695f,      -1.04004f,     -0.344727f,    -0.136719f,
    0.119141f,    -0.385742f,    1.06738f,      -1.01855f,     -0.245117f,
    -0.106445f,   -0.114258f,    -0.365234f,    0.962891f,     -0.923828f,
    -0.430664f,   -0.637695f,    -0.347656f,    -0.436523f,    0.702148f,
    -0.547852f,   -0.618164f,    -0.447266f,    -0.241211f,    -0.462891f,
    0.729492f,    -0.609375f,    -0.578125f,    -0.486328f,    -0.0556641f,
    -0.536133f,   0.50293f,      -0.480469f,    -0.526367f,    -0.210938f,
    -0.0585938f,  -0.637695f,    0.723633f,     -0.319336f,    -0.348633f,
    -0.00292969f, -0.305664f,    -0.629883f,    0.431641f,     0.266602f,
    -0.612305f,   -0.260742f,    0.0166016f,    -0.65332f,     -0.272461f,
    0.800781f,    -1.09863f,     -0.166992f,    -0.0859375f,   -0.520508f,
    -0.473633f,   0.586914f,     -0.696289f,    -0.682617f,    -0.149414f,
    0.198242f,    -0.805664f,    1.1377f,       0.444336f,     -0.458984f,
    -0.577148f,   0.522461f,     -0.683594f,    1.25586f,      0.827148f,
    -0.249023f,   -0.851562f,    0.84668f,      -0.448242f,    1.26953f,
    0.855469f,    -0.155273f,    -0.765625f,    1.0f,          -0.337891f,
    0.973633f,    0.660156f,     -0.0859375f,   -0.476562f,    1.11035f,
    -0.00976562f, 0.547852f,     0.958984f,     -0.34082f,     -0.504883f,
    0.853516f,    0.0664062f,    0.378906f,     0.758789f,     -0.749023f,
    -0.509766f,   0.739258f,     0.499023f,     -0.144531f,    0.84668f,
    -0.931641f,   -0.329102f,    0.740234f,     0.791992f,     -0.168945f,
    0.594727f,    -0.435547f,    -0.268555f,    0.336914f,     0.817383f,
    -0.430664f,   -0.0253906f,   -0.735352f,    -0.0683594f,   0.152344f,
    0.725586f,    -0.68457f,     -0.294922f,    -1.25391f,     -0.125f,
    0.0917969f,   0.907227f,     -0.633789f,    -0.28125f,     -0.222656f,
    0.0f,         0.188477f,     1.06445f,      -0.929688f,    0.144531f,
    -0.139648f,   -0.00390625f,  -0.21582f,     1.21387f,      -0.952148f,
    -0.0253906f,  -0.389648f,    0.148438f,     -0.283203f,    1.14844f,
    -0.890625f,   -0.204102f,    -0.222656f,    -0.0332031f,   -0.451172f,
    0.625f,       -0.486328f,    -0.716797f,    -0.103516f,    0.265625f,
    -0.667969f,   0.231445f,     -0.385742f,    -0.977539f,    0.111328f,
    0.222656f,    -0.766602f,    0.300781f,     -0.390625f,    -1.07129f,
    0.230469f,    0.318359f,     -0.787109f,    0.427734f,     -0.512695f,
    -0.886719f,   0.240234f,     0.260742f,     -0.647461f,    0.566406f,
    -0.686523f,   -0.723633f,    -0.198242f,    0.0722656f,    -0.3125f,
    0.771484f,    -0.725586f,    -0.478516f,    -0.176758f,    -0.113281f,
    -0.262695f,   0.78125f,      -0.644531f,    -0.210938f,    -0.0126953f,
    -0.317383f,   0.0673828f,    0.944336f,     -0.764648f,    0.1875f,
    -0.636719f,   -0.401367f,    0.118164f,     0.982422f,     -0.826172f,
    0.105469f,    -1.0625f,      -0.298828f,    0.0537109f,    0.949219f,
    -0.788086f,   0.176758f,     -0.611328f,    -0.0322266f,   0.0439453f,
    0.885742f,    -0.730469f,    0.301758f,     -0.463867f,    -0.144531f,
    -0.180664f,   1.08398f,      -0.97168f,     -0.470703f,    0.128906f,
    0.0146484f,   -0.112305f,    0.889648f,     -0.946289f,    -0.165039f,
    -1.34277f,    -0.258789f,    -0.211914f,    0.962891f,     -0.844727f,
    -0.588867f,   0.144531f,     -0.228516f,    -0.207031f,    0.974609f,
    -0.848633f,   -0.0273438f,   -0.570312f,    -0.228516f,    0.00195312f,
    1.03125f,     -0.977539f,    -0.0605469f,   -0.733398f,    -0.0908203f,
    0.0996094f,   0.856445f,     -0.854492f,    -0.000976562f, -0.458008f,
    -0.135742f,   0.222656f,     1.34082f,      -1.13574f,     0.639648f,
    0.015625f,    -0.234375f,    0.136719f,     0.835938f,     -0.822266f,
    -0.114258f,   -0.673828f,    -0.186523f,    0.169922f,     0.925781f,
    -0.839844f,   0.175781f,     -0.394531f,    0.224609f,     -0.0458984f,
    0.94043f,     -0.964844f,    -0.0556641f,   -0.15332f,     0.163086f,
    -0.0175781f,  0.944336f,     -0.951172f,    -0.0478516f,   -0.302734f,
    0.117188f,    -0.00683594f,  0.973633f,     -0.970703f,    -0.0810547f,
    -0.301758f,   0.09375f,      -0.000976562f, 1.01953f,      -0.978516f,
    0.0292969f,   -0.293945f,    0.0683594f,    -0.00683594f,  1.0127f,
    -0.966797f,   -0.0175781f,   -0.314453f,    0.181641f,     0.0126953f,
    0.982422f,    -0.990234f,    0.03125f,      -0.194336f,    0.155273f,
    -0.00292969f, 0.962891f,     -0.932617f,    -0.00390625f,  -0.0976562f,
    0.144531f,    -0.0205078f,   0.913086f,     -0.914062f,    -0.0908203f,
    -0.296875f,   0.166992f,     -0.015625f,    0.930664f,     -0.950195f,
    -0.0888672f,  -0.28418f,     0.196289f,     -0.0107422f,   0.953125f,
    -0.960938f,   -0.0273438f,   -0.195312f,    0.125f,        0.0126953f,
    0.986328f,    -0.951172f,    0.0634766f,    -0.231445f,    0.162109f,
    -0.0136719f,  0.981445f,     -0.974609f,    -0.0449219f,   -0.0761719f,
    0.186523f,    -0.015625f,    0.950195f,     -0.962891f,    -0.0576172f,
    -0.162109f,   0.154297f,     -0.0292969f,   0.970703f,     -0.973633f,
    -0.0136719f,  -0.394531f,    0.102539f,     -0.00878906f,  0.970703f,
    -0.915039f,   0.0546875f,    -0.313477f,    0.110352f,     -0.0234375f,
    0.947266f,    -0.922852f,    -0.139648f,    -0.181641f,    0.12207f,
    0.0625f,      0.780273f,     -0.899414f,    -0.84375f,     -0.0888672f,
    -0.318359f,   1.00781f,      0.888672f,     0.27832f,      0.0195312f,
    -1.08594f,    0.137695f,     0.56543f,      1.12891f,      -0.235352f,
    1.65039f,     -0.0820312f,   0.100586f,     0.987305f,     0.261719f,
    -0.0615234f,  1.32227f,      0.669922f,     0.0f,          1.04102f,
    0.231445f,    -0.174805f,    1.11426f,      -0.261719f,    -0.0527344f,
    0.958008f,    0.332031f,     -0.28418f,     1.26953f,      -0.612305f,
    0.208984f,    0.964844f,     1.15625f,      -0.486328f,    2.0f,
    -0.760742f,   0.0458984f,    1.44629f,      1.21289f,      0.924805f,
    1.1875f,      -0.259766f,    0.114258f,     0.210938f,     0.486328f,
    -0.422852f,   -0.984375f,    1.08789f,      0.453125f,     -0.229492f,
    0.457031f,    -0.682617f,    -0.500977f,    0.210938f,     0.391602f,
    -0.303711f,   0.725586f,     -0.80957f,     -0.391602f,    0.0976562f,
    0.958984f,    0.0185547f,    1.69922f,      -1.36035f,     1.98242f,
    -0.392578f,   -0.461914f,    -0.37793f,     -0.0712891f,   0.928711f,
    -1.60254f,    0.133789f,     -0.0419922f,   -1.12109f,     -0.201172f,
    0.0732422f,   -1.99902f,     0.629883f,     -0.174805f,    -0.894531f,
    0.0742188f,   -0.147461f,    -1.23633f,     -0.259766f,    0.0410156f,
    -1.00879f,    -0.0166016f,   -0.0205078f,   -1.99902f,     0.267578f,
    -0.0664062f,  -0.164062f,    0.511719f,     0.825195f,     -1.21191f,
    -0.515625f,   0.46875f,      0.0898438f,    1.09766f,      -0.144531f,
    1.59375f,     0.166016f,     0.428711f,     0.294922f,     0.8125f,
    -0.770508f,   0.535156f,     0.280273f,     0.231445f,     0.504883f,
    0.864258f,    -0.884766f,    0.524414f,     -0.183594f,    0.0820312f,
    0.713867f,    0.405273f,     -0.520508f,    -0.326172f,    0.0126953f,
    -0.310547f,   1.38086f,      0.831055f,     0.380859f,     1.3125f,
    -1.60645f,    0.151367f,     1.01953f,      0.580078f,     -0.0283203f,
    2.0f,         1.03516f,      -0.0634766f,   1.03418f,      0.332031f,
    -0.0859375f,  1.32129f,      -0.234375f,    0.0917969f,    1.49219f,
    0.30957f,     -0.118164f,    1.76953f,      -0.717773f,    0.174805f,
    1.59863f,     0.0947266f,    1.1875f,       0.429688f,     0.442383f,
    0.00976562f,  0.435547f,     0.345703f,     -0.114258f,    0.238281f,
    -0.689453f,   0.30957f,      0.0732422f,    0.606445f,     -0.650391f,
    -0.0947266f,  -0.03125f,     0.183594f,     -0.144531f,    0.746094f,
    -0.793945f,   -0.574219f,    -0.0742188f,   0.196289f,     -0.199219f,
    1.13867f,     -1.11816f,     -0.227539f,    -0.462891f,    0.0517578f,
    -0.0341797f,  1.18945f,      -1.1084f,      -0.0283203f,   -0.342773f,
    0.174805f,    -0.0078125f,   1.05176f,      -1.03906f,     0.0253906f,
    -0.375977f,   -0.169922f,    0.00292969f,   0.837891f,     -0.716797f,
    -0.0205078f,  -0.373047f,    0.293945f,     0.0175781f,    0.833984f,
    -0.916016f,   -0.0996094f,   -0.149414f,    0.200195f,     -0.00195312f,
    0.865234f,    -0.916016f,    -0.0117188f,   -0.390625f,    0.290039f,
    0.0234375f,   0.985352f,     -0.987305f,    0.0439453f,    -0.214844f,
    0.0917969f,   0.0615234f,    1.02832f,      -1.00684f,     0.152344f,
    -0.452148f,   0.0615234f,    -0.00585938f,  1.02148f,      -0.976562f,
    -0.0927734f,  -0.286133f,    0.189453f,     -0.0644531f,   1.02539f,
    -1.02246f,    0.0166016f,    -0.243164f,    0.109375f,     -0.09375f,
    0.981445f,    -0.931641f,    0.0458984f,    -0.460938f,    0.0537109f,
    -0.0429688f,  1.05859f,      -0.850586f,    0.0771484f,    -0.0507812f,
    0.108398f,    -0.177734f,    0.779297f,     -0.74707f,     -0.378906f,
    -0.413086f,   -0.205078f,    -0.0488281f,   0.946289f,     -0.760742f,
    -0.180664f,   -0.228516f,    -0.208008f,    -0.0615234f,   1.05371f,
    -0.953125f,   -0.34668f,     -1.16797f,     -0.0322266f,   -0.276367f,
    1.06641f,     -0.863281f,    -0.0244141f,   -0.290039f,    -0.0429688f,
    0.0439453f,   1.28223f,      -1.06348f,     0.181641f,     -0.514648f,
    -0.0214844f,  0.0f,          0.861328f,     -0.738281f,    -0.0449219f,
    0.0722656f,   0.125f,        0.193359f,     1.15039f,      -1.0957f,
    0.225586f,    -0.137695f,    0.12207f,      -0.0400391f,   0.732422f,
    -0.818359f,   -0.40918f,     -0.672852f,    -0.425781f,    0.839844f,
    0.856445f,    0.198242f,     -0.363281f,    0.206055f,     -0.214844f,
    1.20215f,     0.943359f,     0.0195312f,    2.0f,          0.874023f,
    0.0839844f,   0.827148f,     0.587891f,     -0.384766f,    1.57715f,
    0.108398f,    -0.116211f,    0.952148f,     0.246094f,     -0.336914f,
    0.463867f,    -0.740234f,    0.0185547f,    0.950195f,     0.55957f,
    -0.442383f,   1.09668f,      0.0585938f,    0.132812f,     1.37695f,
    2.0f,         -0.59375f,     2.0f,          -0.676758f,    -0.199219f,
    -0.0205078f,  0.268555f,     -0.5f,         -1.94629f,     1.2832f,
    0.0078125f,   -0.201172f,    0.674805f,     -0.708984f,    -0.490234f,
    -0.515625f,   0.0439453f,    -0.0830078f,   1.14355f,      -1.01953f,
    -0.0224609f,  -0.282227f,    0.0214844f,    -0.078125f,    1.09668f,
    -0.961914f,   0.0253906f,    -0.56543f,     0.30957f,      0.964844f,
    1.56836f,     -0.272461f,    1.91309f,      -0.53418f,     -0.695312f,
    -0.878906f,   -0.0146484f,   0.277344f,     -1.6416f,      0.0244141f,
    0.0898438f,   -0.785156f,    0.229492f,     -0.259766f,    -1.06055f,
    -0.241211f,   0.0224609f,    -0.769531f,    0.748047f,     -0.680664f,
    -0.629883f,   -0.549805f,    -0.195312f,    -0.796875f,    -0.399414f,
    0.0859375f,   -1.99902f,     0.24707f,      0.208984f,     0.563477f,
    1.91797f,     0.0585938f,    2.0f,          -0.990234f,    0.327148f,
    -0.0917969f,  1.16797f,      -0.94043f,     0.623047f,     -1.1748f,
    -0.0205078f,  -0.0449219f,   0.883789f,     -0.905273f,    -0.370117f,
    -0.601562f,   0.0332031f,    -0.0527344f,   0.928711f,     -0.833984f,
    -0.180664f,   -0.267578f,    0.0351562f,    -0.0175781f,   0.998047f,
    -0.922852f,   -0.000976562f, -0.371094f,    0.0341797f,    -0.0166016f,
    0.977539f,    -0.900391f,    -0.00292969f,  -0.37207f,     0.0449219f,
    -0.0439453f,  0.989258f,     -0.904297f,    -0.0576172f,   -0.37207f,
    0.270508f,    -0.368164f,    0.0576172f,    -0.607422f,    -1.95508f,
    -0.182617f,   -0.390625f,    1.62598f,      1.52734f,      1.2793f,
    2.0f,         -1.99902f,     0.226562f,     1.01465f,      0.669922f,
    -0.373047f,   1.71484f,      1.99707f,      -0.0654297f,   1.00391f,
    0.330078f,    -0.432617f,    0.704102f,     -0.96875f,     0.0800781f,
    0.964844f,    0.702148f,     -0.5625f,      1.39746f,      -0.203125f,
    0.255859f,    1.74512f,      1.52539f,      0.417969f,     2.0f,
    -0.0976562f,  -0.482422f,    0.09375f,      0.151367f,     -0.328125f,
    -1.88867f,    -0.0595703f,   0.117188f,     0.0751953f,    0.870117f,
    -0.870117f,   0.046875f,     -0.280273f,    0.125f,        0.124023f,
    1.0791f,      -0.964844f,    0.338867f,     -0.0791016f,   0.0751953f,
    0.12207f,     0.920898f,     -0.888672f,    0.0273438f,    -0.250977f,
    0.00488281f,  0.165039f,     1.01074f,      -0.944336f,    0.137695f,
    -0.387695f,   -0.142578f,    0.238281f,     1.77246f,      -1.42285f,
    0.90625f,     -0.856445f,    0.0556641f,    -0.219727f,    -0.785156f,
    1.47266f,     -1.99902f,     1.27246f,      -0.132812f,    -0.746094f,
    0.172852f,    -0.0830078f,   -1.3584f,      0.638672f,     0.0175781f,
    -0.786133f,   0.754883f,     -0.729492f,    -0.808594f,    -0.291992f,
    0.170898f,    -0.746094f,    0.623047f,     -0.667969f,    -0.743164f,
    -0.241211f,   0.0693359f,    -0.725586f,    0.495117f,     -0.545898f,
    -0.969727f,   -0.131836f,    0.0234375f,    -0.52832f,     0.280273f,
    -0.327148f,   -1.0498f,      -0.210938f,    -0.253906f,    0.234375f,
    0.661133f,    -0.0332031f,   -0.708008f,    -0.458984f,    0.31543f,
    0.480469f,    1.59082f,      -1.22266f,     1.41602f,      -0.270508f,
    0.263672f,    0.318359f,     1.21289f,      -1.12207f,     0.853516f,
    -0.272461f,   0.158203f,     1.84766f,      2.0f,          0.341797f,
    2.0f,         -0.788086f,    -0.264648f,    -0.326172f,    -1.25977f,
    0.842773f,    -1.99902f,     -0.947266f,    0.249023f,     -0.642578f,
    0.745117f,    -0.744141f,    -0.404297f,    -0.266602f,    0.0898438f,
    -0.568359f,   0.501953f,     -0.494141f,    -0.858398f,    0.0722656f,
    -0.543945f,   1.16895f,      1.12012f,      1.47461f,      -1.12988f,
    -0.27832f,    0.53125f,      0.875f,        0.845703f,     -0.318359f,
    1.68555f,     1.29199f,      -0.00195312f,  0.861328f,     0.601562f,
    -0.519531f,   1.16211f,      -1.05957f,     0.0507812f,    0.904297f,
    0.625977f,    -0.525391f,    1.16797f,      -0.163086f,    0.125977f,
    1.99902f,     2.0f,          2.0f,          2.0f,          -0.00195312f,
    -1.11719f,    -0.3125f,      -0.320312f,    0.585938f,     -1.99902f,
    0.647461f,    0.198242f,     -0.538086f,    0.993164f,     -0.897461f,
    -0.227539f,   -0.354492f,    0.0976562f,    -0.416016f,    0.623047f,
    -0.682617f,   -0.832031f,    -0.223633f,    -0.160156f,    0.0751953f,
    -0.791992f,   1.13379f,      -1.99902f,     -0.755859f,    0.669922f,
    1.02637f,     1.26758f,      -0.293945f,    2.0f,          1.93457f,
    -0.0126953f,  0.773438f,     0.475586f,     -0.59375f,     0.329102f,
    -0.588867f,   0.113281f,     0.740234f,     0.749023f,     -0.716797f,
    0.941406f,    -0.0878906f,   0.71875f,      1.8125f,       2.0f,
    -0.289062f,   2.0f,          -1.01074f,     0.0117188f,    -0.183594f,
    -0.969727f,   0.893555f,     -1.99902f,     0.333008f,     0.188477f,
    -0.643555f,   0.504883f,     -0.511719f,    -0.804688f,    -0.957031f,
    0.0546875f,   -0.305664f,    -0.0449219f,   -0.145508f,    -1.875f,
    0.0996094f,   -0.155273f,    1.59668f,      1.5293f,       1.46973f,
    2.0f,         -1.9834f,      0.375f,        1.20508f,      0.736328f,
    -0.399414f,   2.0f,          2.0f,          0.123047f,     0.834961f,
    1.04004f,     -0.808594f,    1.31934f,      -0.634766f,    0.548828f,
    0.129883f,    -1.64746f,     2.0f,          -1.99902f,     0.819336f,
    0.0273438f,   -0.254883f,    0.722656f,     -0.691406f,    -0.464844f,
    -1.05566f,    0.0634766f,    -0.206055f,    1.02148f,      -0.90332f,
    0.0595703f,   -0.03125f,     0.129883f,     -0.177734f,    0.697266f,
    -0.713867f,   -0.351562f,    -0.169922f,    -0.119141f,    -0.172852f,
    1.01855f,     -0.989258f,    -0.12793f,     -0.670898f,    -0.146484f,
    -0.261719f,   1.16602f,      -1.05664f,     -0.302734f,    -0.25293f,
    -0.0458984f,  -0.198242f,    0.90625f,      -0.876953f,    -0.144531f,
    -0.424805f,   -0.151367f,    -0.147461f,    0.926758f,     -0.835938f,
    -0.191406f,   -0.326172f,    -0.128906f,    -0.216797f,    0.910156f,
    -0.851562f,   -0.291992f,    -0.549805f,    -0.0517578f,   -0.0869141f,
    1.07715f,     -0.977539f,    -0.0361328f,   -0.418945f,    -0.148438f,
    -0.133789f,   0.907227f,     -0.836914f,    -0.213867f,    -0.768555f,
    -0.0664062f,  0.182617f,     1.0498f,       -0.915039f,    0.400391f,
    -0.523438f,   0.015625f,     0.0f,          1.13184f,      -1.09961f,
    -0.244141f,   -0.330078f,    -0.115234f,    0.0166016f,    0.944336f,
    -0.868164f,   -0.430664f,    -0.246094f,    -0.0185547f,   -0.00976562f,
    0.819336f,    -0.822266f,    -0.380859f,    -1.1709f,      0.0605469f,
    -0.0498047f,  0.777344f,     -0.703125f,    0.0800781f,    -0.451172f,
    0.304688f,    0.0517578f,    0.825195f,     -0.771484f,    0.145508f,
    0.495117f,    -0.0888672f,   -0.243164f,    1.48145f,      -1.22168f,
    0.0615234f,   -0.192383f,    -0.0537109f,   0.0195312f,    1.21582f,
    -1.06836f,    0.175781f,     -0.394531f,    0.237305f,     -0.0126953f,
    0.800781f,    -0.920898f,    -0.12207f,     -0.391602f,    -0.0917969f,
    -0.0791016f,  1.08008f,      -1.03613f,     -0.0654297f,   -0.423828f,
    0.0478516f,   -0.0253906f,   0.873047f,     -0.884766f,    -0.0722656f,
    -0.579102f,   0.0136719f,    -0.0917969f,   0.954102f,     -0.922852f,
    -0.172852f,   -0.244141f,    0.0f,          -0.141602f,    0.929688f,
    -0.894531f,   -0.179688f,    -0.291992f,    0.0283203f,    -0.0947266f,
    0.961914f,    -0.926758f,    -0.135742f,    -0.329102f,    0.0576172f,
    -0.0351562f,  0.999023f,     -0.958984f,    -0.0498047f,   -0.248047f,
    0.0869141f,   -0.078125f,    1.01074f,      -0.954102f,    0.00976562f,
    -0.217773f,   0.0986328f,    -0.0556641f,   0.916992f,     -0.914062f,
    -0.136719f,   -0.219727f,    0.0488281f,    -0.139648f,    0.985352f,
    -0.952148f,   -0.152344f,    -0.286133f,    0.0166016f,    -0.0917969f,
    1.0459f,      -0.972656f,    -0.0605469f,   -0.228516f,    0.0507812f,
    -0.0810547f,  0.956055f,     -0.9375f,      -0.18457f,     -0.275391f,
    0.0703125f,   -0.0986328f,   0.948242f,     -0.928711f,    -0.162109f,
    -0.333008f};
extern const size_t kAccelerometerLaptopModeTestDataLength =
    base::size(kAccelerometerLaptopModeTestData);

extern const float kAccelerometerFullyOpenTestData[] = {
    0.892578f,    -0.0810547f,  0.0146484f,    0.929688f,     -0.0644531f,
    -0.0234375f,  0.996094f,    -0.0136719f,   0.0185547f,    1.02344f,
    -0.0615234f,  -0.0449219f,  0.978516f,     0.125977f,     0.0400391f,
    0.996094f,    0.0332031f,   -0.0117188f,   0.963867f,     0.107422f,
    0.0214844f,   0.980469f,    0.0185547f,    -0.00683594f,  0.952148f,
    0.0361328f,   0.0253906f,   0.976562f,     -0.00390625f,  -0.0126953f,
    0.97168f,     0.0205078f,   0.0517578f,    1.01074f,      0.015625f,
    -0.0234375f,  0.953125f,    -0.000976562f, 0.0390625f,    0.977539f,
    -0.0224609f,  -0.00976562f, 0.954102f,     0.0244141f,    0.0439453f,
    0.986328f,    0.00292969f,  -0.000976562f, 0.967773f,     0.0537109f,
    0.046875f,    0.99707f,     0.0175781f,    -0.000976562f, 0.951172f,
    0.0390625f,   0.0341797f,   0.974609f,     -0.00878906f,  -0.000976562f,
    0.948242f,    0.0185547f,   0.0478516f,    0.976562f,     -0.000976562f,
    -0.00683594f, 0.958984f,    0.0263672f,    0.078125f,     0.982422f,
    -0.0205078f,  0.0283203f,   0.930664f,     0.00878906f,   0.0664062f,
    0.970703f,    0.00390625f,  -0.0078125f,   0.945312f,     0.0380859f,
    -0.00585938f, 0.972656f,    0.0419922f,    -0.0478516f,   1.01953f,
    0.240234f,    -0.182617f,   1.00977f,      0.18457f,      -0.126953f,
    1.05566f,     0.0751953f,   -0.0888672f,   1.09766f,      0.0732422f,
    -0.0898438f,  1.21484f,     0.119141f,     -0.000976562f, 1.23633f,
    0.194336f,    -0.447266f,   1.31445f,      0.213867f,     -0.118164f,
    1.30762f,     0.0908203f,   -0.260742f,    0.860352f,     0.141602f,
    -0.166016f,   0.868164f,    0.0429688f,    -0.258789f,    0.727539f,
    0.0419922f,   -0.21875f,    0.740234f,     0.0126953f,    -0.162109f,
    0.652344f,    -0.00292969f, -0.185547f,    0.666992f,     0.0800781f,
    -0.272461f,   0.852539f,    -0.0478516f,   -0.228516f,    0.819336f,
    -0.0996094f,  -0.180664f,   0.959961f,     -0.0537109f,   -0.240234f,
    0.935547f,    -0.0917969f,  -0.269531f,    0.988281f,     -0.0507812f,
    -0.197266f,   0.981445f,    -0.0712891f,   -0.323242f,    0.964844f,
    -0.0683594f,  -0.203125f,   0.941406f,     -0.0898438f,   -0.236328f,
    0.942383f,    -0.0429688f,  -0.206055f,    0.921875f,     -0.0527344f,
    -0.239258f,   0.976562f,    -0.0742188f,   -0.261719f,    0.958008f,
    -0.09375f,    -0.311523f,   0.949219f,     -0.0839844f,   -0.242188f,
    0.949219f,    -0.0742188f,  -0.323242f,    0.973633f,     -0.0263672f,
    -0.238281f,   0.958984f,    -0.0488281f,   -0.293945f,    0.931641f,
    -0.0214844f,  -0.225586f,   0.931641f,     0.0195312f,    -0.225586f,
    0.810547f,    -0.0947266f,  -0.15332f,     0.947266f,     0.241211f,
    -0.100586f,   0.326172f,    0.286133f,     -0.12207f,     0.855469f,
    0.677734f,    -0.228516f,   0.229492f,     1.08398f,      0.0224609f,
    0.822266f,    0.759766f,    -0.0722656f,   0.294922f,     1.42676f,
    0.147461f,    0.239258f,    0.755859f,     0.142578f,     -0.120117f,
    1.00977f,     -0.0722656f,  -0.154297f,    0.832031f,     -0.0576172f,
    -0.15332f,    1.10156f,     -0.0273438f,   -0.119141f,    1.05078f,
    0.0166016f,   -0.0927734f,  1.09961f,      -0.0703125f,   -0.0751953f,
    1.04688f,     -0.00195312f, -0.078125f,    0.897461f,     -0.0625f,
    -0.078125f,   0.854492f,    -0.0947266f,   -0.123047f,    0.811523f,
    -0.0488281f,  -0.113281f,   0.796875f,     0.0f,          -0.0488281f,
    0.961914f,    -0.177734f,   -0.0898438f,   0.859375f,     -0.172852f,
    0.0126953f,   1.1084f,      -0.158203f,    0.0292969f,    1.0791f,
    -0.152344f,   0.154297f,    1.29492f,      -0.126953f,    0.134766f,
    1.23145f,     -0.0878906f,  -0.200195f,    0.667969f,     -0.216797f,
    -0.0888672f,  0.935547f,    -0.143555f,    0.000976562f,  1.13281f,
    -0.0498047f,  0.00195312f,  1.05469f,      -0.231445f,    0.0927734f,
    0.956055f,    -0.292969f,   0.0625f,       0.927734f,     -0.112305f,
    0.0585938f,   0.975586f,    -0.163086f,    0.0957031f,    1.03418f,
    -0.229492f,   0.000976562f, 0.985352f,     -0.09375f,     -0.00585938f,
    0.945312f,    -0.140625f,   -0.0302734f,   0.998047f,     -0.208008f,
    -0.0507812f,  0.916016f,    -0.112305f,    0.123047f,     0.981445f,
    -0.205078f,   0.129883f,    1.02832f,      -0.211914f,    0.105469f,
    1.01367f,     -0.142578f,   0.111328f,     1.00098f,      -0.110352f,
    0.0986328f,   0.999023f,    -0.15918f,     0.0839844f,    0.922852f,
    -0.223633f,   0.261719f,    1.06641f,      -0.138672f,    0.240234f,
    0.916016f,    -0.296875f,   0.00488281f,   1.04199f,      -0.128906f,
    0.0341797f,   1.0791f,      -0.265625f,    0.015625f,     0.963867f,
    -0.161133f,   0.015625f,    0.958008f,     -0.0722656f,   -0.125f,
    1.03125f,     -0.19043f,    -0.0722656f,   1.16602f,      -0.126953f,
    -0.143555f,   1.12793f,     -0.197266f,    -0.120117f,    1.26465f,
    -0.232422f,   -0.226562f,   1.125f,        -0.0712891f,   -0.0927734f,
    1.26465f,     -0.145508f,   -0.551758f,    0.90918f,      -0.163086f,
    -0.228516f,   1.2041f,      -0.0371094f,   -0.493164f,    0.827148f,
    0.0371094f,   -0.162109f,   0.568359f,     -0.195312f,    -0.641602f,
    0.438477f,    -0.212891f,   -0.513672f,    0.208008f,     -0.0488281f,
    -0.776367f,   0.0488281f,   -0.115234f,    -0.84375f,     -0.314453f,
    0.106445f,    -0.966797f,   -0.0078125f,   0.00976562f,   -1.01953f,
    -0.220703f,   -0.0322266f,  -0.994141f,    0.0117188f,    -0.248047f,
    -0.975586f,   0.121094f,    -0.0205078f,   -0.947266f,    0.00292969f,
    -0.160156f,   -0.9375f,     0.0175781f,    -0.0986328f,   -0.916992f,
    -0.0195312f,  -0.208008f,   -0.9375f,      -0.0654297f,   -0.134766f,
    -0.948242f,   -0.0185547f,  -0.231445f,    -0.977539f,    -0.0537109f,
    -0.198242f,   -1.0166f,     0.0439453f,    -0.433594f,    -0.994141f,
    -0.0595703f,  -0.389648f,   -1.07129f,     0.0859375f,    -0.109375f,
    -1.01953f,    0.0966797f,   -0.12207f,     -1.01074f,     0.125977f,
    -0.192383f,   -1.0f,        0.0820312f,    -0.166016f,    -1.04688f,
    0.0751953f,   -0.265625f,   -1.00879f,     0.139648f,     -0.135742f,
    -1.00977f,    0.0644531f,   -0.235352f,    -0.989258f,    0.100586f,
    -0.144531f,   -0.858398f,   0.0273438f,    -0.22168f,     -0.878906f,
    -0.0634766f,  -0.1875f,     -0.905273f,    -0.0195312f,   -0.232422f,
    -0.926758f,   -0.0732422f,  -0.319336f,    -1.05078f,     -0.00878906f,
    -0.5625f,     -1.05176f,    0.111328f,     -0.456055f,    -0.942383f,
    -0.0146484f,  -0.171875f,   -0.946289f,    -0.0224609f,   -0.174805f,
    -0.901367f,   -0.0283203f,  -0.332031f,    -0.948242f,    -0.0732422f,
    -0.262695f,   -0.867188f,   0.0351562f,    -0.271484f,    -0.913086f,
    -0.0878906f,  -0.259766f,   -1.2793f,      -0.226562f,    -0.382812f,
    -1.2334f,     0.0400391f,   -0.260742f,    -1.22949f,     -0.216797f,
    -0.432617f,   -1.21191f,    -0.131836f,    -0.368164f,    -1.10938f,
    -0.323242f,   -0.505859f,   -1.01953f,     -0.197266f,    -0.405273f,
    -1.25488f,    -0.347656f,   -0.448242f,    -0.803711f,    0.0595703f,
    -0.253906f,   -0.489258f,   -0.00390625f,  0.101562f,     0.15332f,
    -0.423828f,   -0.0195312f,  0.527344f,     -0.350586f,    -0.24707f,
    0.363281f,    -1.33789f,    -0.214844f,    0.322266f,     -0.768555f,
    -0.279297f,   0.266602f,    -0.918945f,    -0.320312f,    0.0634766f,
    -0.97168f,    -0.102539f,   0.114258f,     -0.891602f,    -0.158203f,
    0.0283203f,   -0.998047f,   -0.198242f,    0.0634766f,    -0.931641f,
    -0.239258f,   0.147461f,    -0.963867f,    -0.219727f,    0.142578f,
    -1.02051f,    -0.279297f,   0.105469f,     -0.955078f,    -0.238281f,
    0.104492f,    -1.02637f,    -0.291992f,    -0.0302734f,   -1.02637f,
    -0.225586f,   0.000976562f, -0.907227f,    -0.12793f,     0.03125f,
    -0.979492f,   -0.100586f,   0.0625f,       -0.921875f,    -0.155273f,
    0.146484f,    -0.929688f,   -0.158203f,    0.155273f,     -0.981445f,
    -0.171875f,   0.212891f,    -0.927734f,    -0.166992f,    0.198242f,
    -1.05371f,    -0.197266f,   0.189453f,     -0.954102f,    -0.113281f,
    0.189453f,    -1.00293f,    -0.180664f,    0.111328f,     -0.967773f,
    -0.109375f,   0.125977f,    -0.966797f,    -0.146484f,    0.0712891f,
    -0.982422f,   -0.0908203f,  0.112305f,     -0.928711f,    -0.149414f,
    0.0146484f,   -1.00781f,    -0.0996094f,   0.102539f,     -0.810547f,
    -0.157227f,   -0.0117188f,  -0.820312f,    -0.0371094f,   0.28418f,
    -0.446289f,   -0.166016f,   0.208008f,     -0.03125f,     -0.0761719f,
    0.755859f,    -0.280273f,   -0.316406f,    1.42188f,      0.198242f,
    -0.49707f,    1.37207f,     -0.556641f,    -0.382812f,    1.36523f,
    0.110352f,    -0.342773f,   1.25391f,      -0.225586f,    -0.570312f,
    0.958984f,    0.0722656f,   -0.237305f,    0.984375f,     0.0957031f,
    -0.416992f,   0.853516f,    0.0400391f,    -0.416016f,    0.873047f,
    0.0644531f,   -0.370117f,   1.04004f,      0.0273438f,    -0.408203f,
    0.920898f,    -0.0986328f,  -0.514648f,    0.956055f,     0.0527344f,
    -0.428711f,   0.960938f,    0.109375f,     -0.522461f,    0.801758f,
    -0.277344f,   -0.634766f,   0.882812f,     0.0527344f,    -0.34668f,
    0.981445f,    -0.09375f,    -0.298828f,    0.952148f,     -0.213867f,
    -0.25293f,    0.90918f,     -0.132812f,    -0.493164f,    0.885742f,
    -0.177734f,   -0.525391f,   0.915039f,     -0.0605469f,   -0.439453f,
    0.87207f,     -0.0986328f,  -0.506836f,    0.905273f,     -0.0732422f,
    -0.462891f,   0.870117f,    -0.0966797f,   -0.511719f,    0.897461f,
    -0.0234375f,  -0.464844f,   0.868164f,     -0.0283203f,   -0.474609f,
    0.919922f,    0.0205078f,   -0.34375f,     0.889648f,     -0.00390625f,
    -0.445312f,   0.804688f,    -0.0263672f,   -0.417969f,    0.806641f,
    0.0410156f,   -0.399414f,   0.914062f,     -0.0722656f,   -0.386719f,
    0.890625f,    -0.0615234f,  -0.40625f,     0.928711f,     0.0253906f,
    -0.118164f,   0.943359f,    -0.000976562f, -0.398438f,    0.811523f,
    -0.0605469f,  -0.234375f,   0.879883f,     0.198242f,     -0.509766f,
    0.958008f,    0.0361328f,   -0.328125f,    0.938477f,     -0.00976562f,
    -0.429688f,   0.916016f,    -0.0185547f,   -0.266602f,    0.898438f,
    -0.0380859f,  -0.450195f,   0.870117f,     0.162109f,     -0.210938f,
    0.899414f,    0.117188f,    -0.517578f,    0.756836f,     -0.0820312f,
    -0.361328f,   0.868164f,    -0.0576172f,   -1.29883f,     0.515625f,
    -0.00195312f, -1.13281f,    0.628906f,     0.00390625f,   -0.103516f,
    0.485352f,    -0.046875f,   -0.922852f,    0.412109f,     -0.108398f,
    -0.898438f,   0.446289f,    -0.111328f,    -0.925781f,    0.375977f,
    -0.125977f,   -0.825195f,   0.446289f,     -0.0966797f,   -0.958008f,
    0.389648f,    -0.0810547f,  -1.00781f,     0.532227f,     -0.104492f,
    -1.0791f,     0.459961f,    -0.138672f,    -0.941406f,    0.509766f,
    -0.107422f,   -1.14062f,    0.447266f,     -0.195312f,    -0.867188f,
    0.474609f,    -0.233398f,   -0.751953f,    0.612305f,     -0.126953f,
    -0.661133f,   0.702148f,    -0.199219f,    -0.260742f,    0.856445f,
    -0.0292969f,  -0.743164f,   0.921875f,     -0.0371094f,   -0.293945f,
    0.902344f,    -0.103516f,   -0.416016f,    0.955078f,     -0.00488281f,
    -0.232422f,   0.951172f,    -0.0498047f,   -0.331055f,    0.871094f,
    0.00390625f,  -0.186523f,   0.905273f,     0.0566406f,    -0.249023f,
    0.677734f,    0.0253906f,   0.145508f,     0.826172f,     0.251953f,
    -0.428711f,   0.764648f,    0.488281f,     -0.265625f,    0.886719f,
    0.256836f,    -0.408203f,   0.744141f,     0.689453f,     -0.611328f,
    0.755859f,    0.431641f,    -0.525391f,    0.588867f,     0.637695f,
    -0.750977f,   0.578125f,    0.568359f,     -0.540039f,    0.512695f,
    0.530273f,    -0.722656f,   0.498047f,     0.526367f,     -0.788086f,
    0.647461f,    0.522461f,    -0.862305f,    0.567383f,     0.422852f,
    -0.765625f,   0.648438f,    0.405273f,     -0.938477f,    0.583008f,
    0.272461f,    -1.15137f,    0.481445f,     0.00585938f,   -0.788086f,
    0.454102f,    -0.0615234f,  -0.885742f,    0.306641f,     -0.333984f,
    -0.678711f,   0.322266f,    -0.288086f,    -0.615234f,    0.220703f,
    -0.476562f,   -0.748047f,   0.223633f,     -0.396484f,    -0.729492f,
    0.235352f,    -0.510742f,   -0.806641f,    0.227539f,     -0.476562f,
    -0.665039f,   0.275391f,    -0.47168f,     -0.938477f,    0.345703f,
    -0.369141f,   -0.709961f,   0.482422f,     -0.393555f,    -0.380859f,
    0.759766f,    -0.143555f,   -0.529297f,    0.956055f,     -0.0185547f,
    -0.12207f,    1.15527f,     0.0380859f,    -0.529297f,    1.04102f,
    0.203125f,    -0.0283203f,  1.11719f,      0.0888672f,    -0.258789f,
    1.02734f,     0.297852f,    -0.0244141f,   1.03223f,      0.211914f,
    -0.0859375f,  0.798828f,    0.216797f,     0.19043f,      0.891602f,
    0.256836f,    -0.102539f,   0.662109f,     0.263672f,     0.208984f,
    0.810547f,    0.380859f,    -0.235352f,    0.707031f,     0.507812f,
    -0.0800781f,  0.902344f,    0.470703f,     -0.301758f,    0.577148f,
    0.674805f,    -0.500977f,   0.748047f,     0.472656f,     -0.493164f,
    0.478516f,    0.611328f,    -1.04395f,     0.491211f,     0.651367f,
    -0.581055f,   0.25293f,     0.325195f,     -0.950195f,    0.224609f,
    0.404297f,    -1.04883f,    0.116211f,     -0.00292969f,  -0.980469f,
    0.0566406f,   0.0195312f,   -0.821289f,    0.0166016f,    -0.141602f,
    -0.959961f,   -0.0322266f,  -0.158203f,    -0.837891f,    0.119141f,
    -0.224609f,   -1.00781f,    0.09375f,      -0.151367f,    -1.00684f,
    0.248047f,    -0.238281f,   -0.973633f,    0.271484f,     -0.324219f,
    -0.942383f,   0.443359f,    -0.298828f,    -0.845703f,    0.581055f,
    -0.291992f,   -0.700195f,   0.65918f,      -0.319336f,    -0.262695f,
    0.818359f,    -0.286133f,   -0.579102f,    0.827148f,     -0.272461f,
    -0.0908203f,  0.935547f,    -0.233398f,    -0.374023f,    0.920898f,
    -0.137695f,   0.000976562f, 0.964844f,     -0.12793f,     -0.285156f,
    0.880859f,    -0.0244141f,  -0.0830078f,   0.930664f,     0.00976562f,
    -0.15332f,    0.731445f,    0.172852f,     0.0380859f,    0.876953f,
    0.264648f,    -0.194336f,   0.601562f,     0.613281f,     -0.132812f,
    0.803711f,    0.53418f,     -0.268555f,    0.933594f,     0.899414f,
    -0.332031f,   0.923828f,    0.521484f,     -0.425781f,    0.972656f,
    0.959961f,    -0.506836f,   0.797852f,     0.506836f,     -0.125977f,
    0.740234f,    0.756836f,    -0.262695f,    0.783203f,     0.691406f,
    -0.422852f,   0.474609f,    0.459961f,     0.00390625f,   0.683594f,
    0.941406f,    -0.0625f,     0.0810547f,    1.06934f,      0.0625f,
    0.546875f,    0.967773f,    0.0351562f,    0.202148f,     1.32422f,
    -0.148438f,   0.269531f,    0.818359f,     -0.3125f,      0.0742188f,
    1.23633f,     -0.188477f,   -0.0263672f,   0.713867f,     -0.139648f,
    -0.230469f,   0.8125f,      -0.134766f,    -0.246094f,    0.734375f,
    -0.09375f,    -0.22168f,    1.17188f,      -0.158203f,    -0.209961f,
    1.09766f,     -0.141602f,   0.00976562f,   0.991211f,     -0.238281f,
    0.0341797f,   0.979492f,    -0.207031f,    -0.0166016f,   1.00293f,
    -0.228516f,   0.0527344f,   1.28711f,      -0.167969f,    0.164062f,
    0.925781f,    -0.255859f,   0.170898f,     0.956055f,     -0.256836f,
    0.191406f,    0.936523f,    -0.145508f,    0.205078f,     0.904297f,
    -0.257812f,   0.117188f,    0.870117f,     -0.188477f,    0.166992f,
    1.02441f,     -0.288086f,   0.163086f,     0.938477f,     -0.262695f,
    0.138672f,    0.947266f,    -0.219727f,    0.0947266f,    0.992188f,
    -0.0732422f,  0.116211f,    1.00293f,      -0.203125f,    0.0205078f,
    0.933594f,    -0.235352f,   -0.0126953f,   0.844727f,     -0.0693359f,
    0.119141f,    1.00195f,     -0.110352f,    0.135742f,     1.00391f,
    -0.101562f,   0.0546875f,   1.06543f,      -0.18457f,     0.0507812f,
    0.933594f,    -0.112305f,   0.00976562f,   0.973633f,     -0.193359f,
    -0.0185547f,  0.885742f,    -0.279297f,    -0.0107422f,   1.02344f,
    -0.078125f,   -0.0107422f,  1.0127f,       0.140625f,     -0.142578f,
    0.994141f,    -0.132812f,   -0.145508f,    0.90918f,      -0.000976562f,
    -0.22168f,    1.0498f,      -0.148438f,    -0.185547f,    1.2207f,
    -0.172852f,   -0.196289f,   1.0957f,       -0.183594f,    -0.0390625f,
    1.34863f,     -0.21875f,    -0.745117f,    0.952148f,     0.0126953f,
    -0.196289f,   1.29492f,     -0.150391f,    -0.768555f,    0.853516f,
    -0.163086f,   -0.25f,       0.358398f,     -0.0507812f,   -0.80957f,
    0.139648f,    0.125f,       -0.790039f,    -0.257812f,    0.175781f,
    -0.795898f,   -0.135742f,   0.00585938f,   -0.841797f,    -0.279297f,
    0.0419922f,   -0.708984f,   0.0175781f,    -0.0957031f,   -0.75f,
    -0.204102f,   0.0419922f,   -0.78125f,     0.0322266f,    -0.125f,
    -0.787109f,   -0.0380859f,  -0.0683594f,   -1.06641f,     0.0947266f,
    -0.238281f,   -1.02148f,    0.117188f,     -0.176758f,    -1.77539f,
    0.0117188f,   -0.31543f,    -1.80566f,     -0.0625f,      -0.273438f,
    -0.764648f,   0.143555f,    -0.21875f,     -0.746094f,    0.162109f,
    -0.0351562f,  -0.858398f,   0.186523f,     -0.250977f,    -0.918945f,
    0.0458984f,   0.135742f,    -0.988281f,    0.241211f,     -0.192383f,
    -0.963867f,   0.277344f,    -0.129883f,    -0.994141f,    0.22168f,
    -0.169922f,   -0.96582f,    0.290039f,     -0.217773f,    -0.990234f,
    0.185547f,    -0.152344f,   -0.978516f,    0.169922f,     -0.0361328f,
    -0.912109f,   0.119141f,    -0.352539f,    -0.838867f,    0.183594f,
    -0.0380859f,  -0.753906f,   0.274414f,     -0.575195f,    -0.770508f,
    0.192383f,    -0.482422f,   -0.904297f,    -0.0234375f,   -0.498047f,
    -0.817383f,   0.0527344f,   -0.277344f,    -0.428711f,    0.114258f,
    -0.634766f,   -0.427734f,   -0.0429688f,   -0.405273f,    -0.318359f,
    0.118164f,    -0.870117f,   -0.193359f,    0.171875f,     -0.938477f,
    -0.1875f,     0.208008f,    -1.04688f,     -0.246094f,    0.0849609f,
    -1.72461f,    -0.353516f,   0.234375f,     -1.05859f,     -0.304688f,
    0.151367f,    -1.38672f,    -0.663086f,    0.242188f,     -0.939453f,
    -0.481445f,   0.189453f,    -0.87793f,     -0.831055f,    0.358398f,
    -0.555664f,   -0.621094f,   0.444336f,     -0.287109f,    -0.802734f,
    0.367188f,    -0.25293f,    -0.753906f,    0.413086f,     0.0126953f,
    -1.0127f,     0.335938f,    -0.250977f,    -0.942383f,    0.563477f,
    0.000976562f, -1.33691f,    0.138672f,     -0.365234f,    -0.996094f,
    0.542969f,    -0.0400391f,  -1.44434f,     0.239258f,     -0.655273f,
    -0.625977f,   0.313477f,    -0.444336f,    -0.589844f,    -0.106445f,
    -0.217773f,   0.00585938f,  -0.760742f,    -0.219727f,    0.0654297f,
    -0.626953f,   -0.0439453f,  0.0732422f,    -1.22168f,     0.0126953f,
    0.210938f,    -0.754883f,   -0.0839844f,   0.161133f,     -0.980469f,
    -0.124023f,   0.141602f,    -0.828125f,    -0.199219f,    0.152344f,
    -0.80957f,    -0.230469f,   0.231445f,     -0.865234f,    -0.259766f,
    0.232422f,    -0.892578f,   -0.305664f,    0.323242f,     -0.87793f,
    -0.294922f,   0.274414f,    -1.0791f,      -0.435547f,    0.222656f,
    -0.863281f,   -0.375f,      0.219727f,     -1.0166f,      -0.525391f,
    0.0341797f,   -0.834961f,   -0.454102f,    0.0371094f,    -0.984375f,
    -0.486328f,   -0.135742f,   -0.700195f,    -0.339844f,    -0.0078125f,
    -1.20508f,    -0.665039f,   -0.791016f,    0.00390625f,   -0.277344f,
    0.0136719f,   -0.492188f,   -0.779297f,    -1.49316f,     0.0957031f,
    -0.179688f,   -0.587891f,   0.665039f,     0.398438f,     -0.980469f,
    0.428711f,    0.254883f,    -0.828125f,    0.724609f,     0.663086f,
    -0.90625f,    0.555664f,    0.0791016f,    -0.837891f,    0.591797f,
    0.257812f,    -0.806641f,   0.609375f,     0.0458984f,    -0.779297f,
    0.529297f,    0.00292969f,  -0.829102f,    0.640625f,     0.0371094f,
    -0.797852f,   0.583008f,    0.208984f,     -0.864258f,    0.583984f,
    -0.0615234f,  -0.758789f,   0.72168f,      0.0947266f,    -0.921875f,
    0.605469f,    -0.264648f,   -0.75293f,     0.701172f,     0.107422f,
    -0.735352f,   0.44043f,     -0.527344f,    -0.398438f,    0.46875f,
    -0.421875f,   -0.424805f,   0.0810547f,    -0.754883f,    -0.241211f,
    -0.107422f,   -1.13574f,    -0.410156f,    -0.0400391f,   -0.942383f,
    -0.454102f,   -0.12207f,    -1.24902f,     -0.509766f,    -0.393555f,
    -0.959961f,   -0.511719f,   -0.381836f,    -1.04883f,     -0.924805f,
    -0.756836f,   -1.17969f,    -0.521484f,    -0.105469f,    -1.16504f,
    -0.767578f,   -0.477539f,   -0.401367f,    -0.0341797f,   -0.341797f,
    0.0507812f,   0.389648f,    -0.507812f,    0.186523f,     0.438477f,
    -1.33594f,    0.625977f,    0.518555f,     -0.671875f,    0.182617f,
    0.432617f,    -1.18359f,    0.132812f,     0.414062f,     -0.782227f,
    0.0615234f,   0.401367f,    -1.30176f,     -0.0683594f,   -0.100586f,
    -0.586914f,   0.0302734f,   0.191406f,     -0.983398f,    -0.0273438f,
    -0.735352f,   -0.224609f,   -0.342773f,    -0.241211f,    -0.566406f,
    0.015625f,    -1.1084f,     -0.00976562f,  -0.652344f,    -0.75293f,
    0.239258f,    -0.449219f,   -1.08789f,     0.107422f,     -0.572266f,
    -0.887695f,   0.407227f,    -0.423828f,    -0.919922f,    0.173828f,
    -0.705078f,   -0.825195f,   0.411133f,     -0.484375f,    -0.799805f,
    0.237305f,    -0.776367f,   -0.745117f,    0.459961f,     -0.819336f,
    -0.749023f,   0.208008f,    -0.788086f,    -0.716797f,    0.226562f,
    -0.795898f,   -0.72168f,    0.123047f,     -0.790039f,    -0.705078f,
    0.101562f,    -0.720703f,   -0.745117f,    -0.0517578f,   -0.771484f,
    -0.701172f,   -0.0175781f,  -0.758789f,    -0.765625f,    -0.0917969f,
    -0.745117f,   -0.751953f,   -0.149414f,    -0.6875f,      -0.660156f,
    -0.0166016f,  -0.782227f,   -0.592773f,    -0.0205078f,   -0.726562f,
    -0.376953f,   0.119141f,    -0.599609f,    -0.371094f,    0.0107422f,
    -0.736328f,   -0.325195f,   0.0771484f,    -0.768555f,    -0.388672f,
    -0.0273438f,  -0.750977f,   -0.477539f,    0.107422f,     -0.919922f,
    -0.514648f,   0.125f,       -0.961914f,    -0.37793f,     0.0136719f,
    -0.981445f,   -0.447266f,   -0.0107422f,   -0.823242f,    -0.303711f,
    0.0986328f,   -1.00684f,    -0.366211f,    0.0986328f,    -1.14551f,
    -0.239258f,   0.140625f,    -0.894531f,    -0.297852f,    0.0849609f,
    -0.949219f,   -0.341797f,   0.131836f,     -0.966797f,    -0.380859f,
    0.0947266f,   -0.75293f,    -0.391602f,    0.0839844f,    -0.908203f,
    -0.40625f,    0.161133f,    -0.860352f,    -0.452148f,    0.1875f,
    -0.950195f,   -0.496094f,   0.200195f,     -0.828125f,    -0.581055f,
    0.0771484f,   -0.93457f,    -0.607422f,    0.0996094f,    -0.863281f,
    -0.59375f,    0.0927734f,   -0.802734f,    -0.604492f,    0.0947266f,
    -0.807617f,   -0.722656f,   0.101562f,     -0.844727f,    -0.711914f,
    0.149414f,    -1.03125f,    -0.77832f,     0.125977f,     -0.78418f,
    -0.740234f,   0.121094f,    -0.891602f,    -0.808594f,    0.164062f,
    -0.650391f,   -0.80957f,    0.0888672f,    -0.416992f,    -0.866211f,
    0.155273f,    -0.382812f,   -0.880859f,    0.0849609f,    -0.264648f,
    -0.775391f,   0.229492f,    -0.389648f,    -0.814453f,    0.0664062f,
    -0.226562f,   -0.625f,      0.414062f,     -0.274414f,    -0.681641f,
    0.0292969f,   -0.0478516f,  -0.711914f,    0.794922f,     -0.388672f,
    -0.584961f,   0.368164f,    -0.257812f,    -0.545898f,    1.09277f,
    -0.277344f,   -0.125977f,   0.822266f,     -0.365234f,    -0.467773f,
    0.714844f,    -0.413086f,   -0.136719f,    1.57227f,      -0.0947266f,
    -0.223633f,   0.817383f,    -0.0556641f,   -0.0322266f,   1.18945f,
    -0.191406f,   -0.498047f,   0.991211f,     -0.231445f,    -0.246094f,
    0.8125f,      -0.239258f,   -0.755859f,    0.853516f,     -0.228516f,
    -0.821289f,   0.503906f,    -0.121094f,    -0.795898f,    0.523438f,
    -0.220703f,   -0.773438f,   0.517578f,     -0.274414f,    -0.757812f,
    0.539062f,    -0.222656f,   -0.770508f,    0.396484f,     -0.115234f,
    -1.2334f,     0.485352f,    -0.217773f,    -0.94043f,     1.01758f,
    -0.202148f,   -0.605469f,   0.0546875f,    0.0957031f,    -0.639648f,
    -0.661133f,   0.245117f,    -0.750977f,    0.0615234f,    -0.726562f,
    -0.879883f,   -0.432617f,   -1.05859f,     -1.29688f,     0.00488281f,
    0.193359f,    -0.939453f,   0.209961f,     -0.209961f,    -0.793945f,
    0.251953f,    0.722656f,    -0.447266f,    0.0615234f,    0.855469f,
    -0.454102f,   -0.0126953f,  0.0527344f,    -0.342773f,    0.154297f,
    1.3877f,      -0.65918f,    0.133789f,     0.0576172f,    -0.233398f,
    -0.12207f,    0.46582f,     -1.09961f,     0.438477f,     -0.641602f,
    -0.861328f,   0.197266f,    -1.99902f,     -0.932617f,    0.234375f,
    0.389648f,    -0.792969f,   -0.0908203f,   1.66797f,      -1.0459f,
    0.0107422f,   -0.543945f,   -0.80957f,     0.206055f,     -0.27832f,
    -0.915039f,   0.104492f,    -0.301758f,    -0.891602f,    0.0556641f,
    -0.681641f,   -0.901367f,   0.0498047f,    -0.461914f,    -0.927734f,
    -0.0390625f,  -0.229492f,   -1.04004f,     0.0869141f,    -0.435547f,
    -1.02148f,    0.0947266f,   -0.527344f,    -0.979492f,    0.0751953f,
    0.266602f,    -0.786133f,   -0.0224609f,   -0.0947266f,   -0.702148f,
    -0.00683594f, -0.316406f,   -0.698242f,    -0.317383f,    1.92578f,
    -1.0498f,     0.0273438f,   -1.14258f,     -0.226562f,    0.233398f,
    -0.995117f,   -0.9375f,     0.0146484f,    -0.223633f,    -0.49707f,
    -0.0078125f,  -1.95703f,    -0.847656f,    0.157227f,     0.129883f,
    -0.459961f,   -0.114258f,   2.0f,          -1.13574f,     -0.0839844f,
    -0.0878906f,  -0.783203f,   0.131836f,     -0.803711f,    -0.90332f,
    0.208984f,    -0.365234f,   -0.97168f,     -0.0322266f,   0.186523f,
    -0.924805f,   0.00292969f,  -0.272461f,    -0.890625f,    0.015625f,
    -0.333008f,   -0.932617f,   0.180664f,     -0.459961f,    -0.90918f,
    0.240234f,    -0.625977f,   -1.1582f,      0.0996094f,    -0.170898f,
    -1.08887f,    -0.00976562f, -0.849609f,    -0.430664f,    0.139648f,
    -0.308594f,   -0.572266f,   -0.722656f,    1.83496f,      -1.00977f,
    0.387695f,    0.487305f,    -0.268555f,    0.0712891f,    -0.0136719f,
    -1.5332f,     0.290039f,    -0.0351562f,   -0.861328f,    1.98535f,
    -1.16602f,    -0.602539f,   0.441406f,     0.175781f,     -0.605469f,
    -0.831055f,   0.686523f,    -0.984375f,    0.494141f,     -0.489258f,
    -0.895508f,   0.371094f,    -0.665039f,    -1.14258f,     -0.214844f,
    -0.140625f,   -1.06348f,    -0.0996094f,   0.255859f,     -0.874023f,
    0.193359f,    -0.0947266f,  -0.959961f,    -0.0966797f,   0.00195312f,
    -0.996094f,   -0.0117188f,  -0.174805f,    -0.962891f,    0.106445f,
    -0.162109f,   -1.04297f,    -0.0283203f,   -0.306641f,    -1.06738f,
    -0.0224609f,  -0.129883f,   -1.03223f,     0.129883f,     0.195312f,
    -1.08789f,    -0.130859f,   0.649414f,     -0.572266f,    -0.0136719f,
    -0.793945f,   -0.382812f,   0.0f,          -1.08301f,     -0.78125f,
    -0.0224609f,  -0.339844f,   -0.629883f,    -0.0947266f,   -1.83789f,
    -1.01562f,    0.046875f,    0.223633f,     -0.808594f,    0.0957031f,
    1.09766f,     -0.756836f,   -0.0488281f,   0.157227f,     -0.59082f,
    -0.103516f,   0.929688f,    -0.816406f,    -0.0322266f,   -0.426758f,
    -0.868164f,   -0.209961f,   -1.99902f,     -0.986328f,    -0.00878906f,
    -0.365234f,   -0.980469f,   0.0439453f,    0.59375f,      -0.994141f,
    0.0253906f,   0.0371094f,   -0.970703f,    -0.0273438f,   -0.120117f,
    -0.935547f,   0.00195312f,  -0.235352f,    -0.952148f,    -0.0263672f,
    -0.194336f,   -0.917969f,   -0.0195312f,   -0.261719f,    -0.928711f,
    -0.0234375f,  -0.219727f,   -0.945312f,    0.0107422f,    -0.228516f,
    -0.938477f,   0.00683594f,  -0.178711f,    -0.791016f,    0.03125f,
    -0.255859f,   -0.789062f,   0.0f,          -0.141602f,    -0.789062f,
    0.232422f,    -0.285156f,   -0.788086f,    0.228516f,     -0.28125f,
    -1.0f,        0.258789f,    -0.277344f,    -0.999023f,    0.28125f,
    -0.25293f,    -1.06152f,    0.046875f,     -0.421875f,    -1.07715f,
    0.0390625f,   -0.224609f,   -0.923828f,    -0.0205078f,   -0.335938f,
    -0.984375f,   -0.0966797f,  -0.34668f,     -0.990234f,    -0.191406f,
    -0.301758f,   -1.03613f,    -0.241211f,    -0.37207f,     -0.975586f,
    -0.267578f,   -0.460938f,   -1.00977f,     -0.320312f,    -0.382812f,
    -0.913086f,   -0.257812f,   -0.457031f,    -0.925781f,    -0.256836f,
    -0.34668f,    -0.889648f,   -0.237305f,    -0.393555f,    -0.897461f,
    -0.239258f,   -0.429688f,   -0.844727f,    -0.21875f,     -0.428711f,
    -0.87207f,    -0.203125f,   -0.368164f,    -0.84668f,     -0.101562f,
    -0.423828f,   -0.875977f,   -0.165039f,    -0.363281f,    -0.884766f,
    -0.0625f,     -0.473633f,   -0.90332f,     -0.078125f,    -0.138672f,
    -0.918945f,   -0.198242f,   -0.25f,        -0.928711f,    -0.138672f,
    -0.267578f,   -1.08203f,    0.00488281f,   -0.575195f,    -1.125f,
    -0.0332031f,  -0.4375f,     -0.924805f,    0.078125f,     -0.305664f,
    -0.93457f,    -0.0166016f,  -0.475586f,    -0.94043f,     -0.00488281f,
    -0.533203f,   -0.956055f,   0.00292969f,   -0.391602f,    -1.00293f,
    0.0361328f,   -0.711914f,   -1.0166f,      0.0332031f,    -0.448242f,
    -0.806641f,   -0.21582f,    -0.556641f,    -0.759766f,    -0.0214844f,
    -0.626953f,   -0.700195f,   -0.263672f,    -0.308594f,    -0.608398f,
    -0.236328f,   -0.253906f,   -0.616211f,    -0.378906f,    0.224609f,
    -0.498047f,   -0.399414f,   0.206055f,     -0.516602f,    -0.228516f,
    0.743164f,    -0.174805f,   -0.125f,       0.760742f,     -0.0214844f,
    -0.135742f,   0.966797f,    0.240234f,     0.0332031f,    1.01855f,
    0.105469f,    0.15332f,     0.950195f,     0.240234f,     0.0732422f,
    1.16895f,     0.245117f,    0.206055f,     0.952148f,     0.273438f,
    -0.0390625f,  1.2793f,      0.404297f,     0.303711f,     0.720703f,
    0.369141f,    0.0966797f,   0.918945f,     0.329102f,     0.0390625f,
    0.991211f,    0.397461f,    -0.124023f,    0.866211f,     0.210938f,
    0.130859f,    1.08789f,     0.317383f,     0.0537109f,    0.858398f,
    0.245117f,    0.0732422f,   0.741211f,     0.419922f,     0.0302734f,
    0.681641f,    0.485352f,    -0.0214844f,   0.641602f,     0.520508f,
    -0.129883f,   0.839844f,    0.490234f,     0.00390625f,   0.676758f,
    0.581055f,    -0.0146484f,  0.692383f,     0.432617f,     -0.0371094f,
    0.807617f,    0.664062f,    0.255859f,     0.216797f,     1.22559f,
    0.0195312f,   1.22168f,     1.2793f,       -0.405273f,    1.72559f,
    0.708984f,    -0.209961f,   0.579102f,     0.821289f,     0.0380859f,
    0.605469f,    0.80957f,     0.147461f,     0.419922f,     0.869141f,
    0.0390625f,   0.5625f,      0.786133f,     0.0654297f,    0.594727f,
    0.879883f,    0.0166016f,   0.480469f,     0.835938f,     0.00195312f,
    0.414062f,    0.899414f,    -0.03125f,     0.344727f,     0.889648f,
    0.0185547f,   0.236328f,    0.932617f,     -0.00585938f,  0.255859f,
    0.910156f,    0.0898438f,   0.262695f,     0.945312f,     0.0126953f,
    0.279297f,    0.860352f,    0.0507812f,    0.322266f,     0.913086f,
    0.00195312f,  0.296875f,    0.875977f,     0.0078125f,    0.373047f,
    0.922852f,    -0.0244141f,  0.267578f,     0.884766f,     0.0117188f,
    0.347656f,    0.926758f,    -0.0371094f,   0.266602f,     0.894531f,
    -0.00683594f, 0.345703f,    0.926758f,     -0.0478516f,   0.269531f,
    0.887695f,    0.0146484f,   0.360352f,     0.927734f,     -0.03125f,
    0.272461f};
extern const size_t kAccelerometerFullyOpenTestDataLength =
    base::size(kAccelerometerFullyOpenTestData);

extern const float kAccelerometerVerticalHingeTestData[] = {
    -0.0766145f,  6.02381f,     7.85298f,     -0.268151f,   -8.84897f,
    -1.3216f,     -0.402226f,   5.11401f,     8.77236f,     -1.10133f,
    -10.1706f,    1.24498f,     -1.18752f,    6.40688f,     8.0924f,
    -2.60489f,    -8.99262f,    2.58574f,     0.632069f,    9.05008f,
    3.61046f,     1.50356f,     -9.67257f,    1.93451f,     0.411803f,
    8.81066f,     0.268151f,    -0.00957681f, -8.7532f,     2.15478f,
    -0.0191536f,  9.49062f,     -0.68953f,    0.0383072f,   -8.94474f,
    2.99754f,     -0.871489f,   9.80665f,     1.53229f,     -0.92895f,
    -9.88326f,    0.957681f,    0.507571f,    9.19373f,     1.71425f,
    0.287304f,    -9.03093f,    0.651223f,    0.363919f,    9.71088f,
    1.18752f,     1.10133f,     -10.0556f,    2.98796f,     0.23942f,
    9.39485f,     1.0343f,      0.842759f,    -9.73961f,    -1.12049f,
    0.172383f,    9.50977f,     1.18752f,     0.0383072f,   -9.9503f,
    0.957681f,    -0.373495f,   9.96946f,     1.01514f,     0.794875f,
    -10.1897f,    -1.38864f,    -9.50977f,    -1.04387f,    0.325611f,
    -9.76834f,    1.05345f,     -0.679953f,   -9.76834f,    -0.641646f,
    0.488417f,    -9.2895f,     0.316035f,    0.258574f,    -9.29908f,
    -0.890643f,   0.469264f,    -9.33739f,    0.823605f,    -0.45011f,
    -9.69173f,    -1.02472f,    0.536301f,    -9.52892f,    0.90022f,
    -0.411803f,   -9.34696f,    -0.890643f,   0.430956f,    -9.48104f,
    0.823605f,    -0.603339f,   -9.7875f,     -0.565032f,   0.574608f,
    -9.96946f,    0.536301f,    -0.699107f,   -9.57681f,    -0.823605f,
    0.641646f,    -9.43316f,    0.593762f,    -0.775721f,   -9.35654f,
    -1.04387f,    0.440533f,    -9.77792f,    1.01514f,     -0.881066f,
    -9.32781f,    -1.10133f,    0.306458f,    -9.414f,      0.995988f,
    0.0287304f,   -9.26077f,    -1.01514f,    0.268151f,    -9.29908f,
    0.881066f,    0.00957681f,  -9.42358f,    -0.679953f,   0.201113f,
    -9.49062f,    0.488417f,    -0.00957681f, -9.47146f,    -0.363919f,
    0.191536f,    -9.32781f,    0.124498f,    0.124498f,    -9.5385f,
    -0.0766145f,  0.268151f,    -9.32781f,    -0.172383f,   0.0574608f,
    -9.69173f,    0.21069f,     0.354342f,    -9.50019f,    -0.306458f,
    0.0383072f,   -9.54808f,    0.507571f,    0.363919f,    -9.20331f,
    -0.775721f,   0.0574608f,   -9.59596f,    0.651223f,    0.679953f,
    -9.56723f,    -0.794875f,   -0.0287304f,  -9.49062f,    0.794875f,
    0.612916f,    -9.06924f,    -1.10133f,    -0.201113f,   -9.20331f,
    1.90578f,     1.46525f,     -9.29908f,    -2.17394f,    0.603339f,
    -0.995988f,   0.0766145f,   9.58638f,     -0.344765f,   -0.92895f,
    -9.1267f,     -2.03986f,    -0.497994f,   10.477f,      -2.49955f,
    -0.0957681f,  -10.4866f,    -1.5706f,     -0.23942f,    9.13627f,
    -1.92494f,    -0.325611f,   -9.05008f,    -1.5706f,     -0.0383072f,
    10.1323f,     -1.87705f,    -0.632069f,   -9.52892f,    -1.20668f,
    0.105345f,    9.14585f,     -1.13964f,    -0.718261f,   -9.02135f,
    -1.58975f,    0.296881f,    9.50019f,     -1.74298f,    -1.00556f,
    -9.27993f,    -1.09176f,    0.23942f,     9.87369f,     -1.04387f,
    -0.995988f,   -9.35654f,    -2.08774f,    -0.526724f,   9.89284f,
    -1.40779f,    -0.459687f,   -9.50977f,    -2.70066f,    -1.47483f,
    8.95431f,     -1.92494f,    0.526724f,    -8.95431f,    -1.05345f,
    -0.938527f,   9.14585f,     -3.02627f,    1.04387f,     -8.78193f,
    1.00556f,     -3.56257f,    9.0022f,      1.96325f,     2.36547f,
    -9.83538f,    1.02472f,     -2.59531f,    9.49062f,     1.0726f,
    1.77171f,     -9.06924f,    0.0861913f,   -2.17394f,    9.21289f,
    -0.823605f,   1.52271f,     -10.1323f,    0.316035f,    -3.09331f,
    10.0844f,     0.555455f,    2.00155f,     -9.75877f,    1.51314f,
    -2.24097f,    9.61511f,     0.670376f,    1.35033f,     -9.77792f,
    0.986411f,    -3.36146f,    9.59596f,     1.77171f,     2.29843f,
    -9.48104f,    1.4461f,      -2.8922f,     8.88728f,     1.84832f,
    2.38462f,     -9.19373f,    1.75256f,     -2.6432f,     9.89284f,
    1.38864f,     2.19309f,     -9.20331f,    9.98861f,     -0.718261f,
    -0.746991f,   10.6111f,     0.632069f,    0.948104f,    8.99262f,
    -0.258574f,   0.517148f,    9.10754f,     0.21069f,     -1.21625f,
    9.90242f,     -0.162806f,   0.0287304f,   10.5249f,     -0.0861913f,
    0.229843f,    9.83538f,     0.0f,         0.181959f,    10.4291f,
    -0.172383f,   -0.47884f,    9.43316f,     0.201113f,    -0.268151f,
    9.76834f,     -0.134075f,   -0.354342f,   10.0556f,     1.0726f,
    0.277727f,    9.93115f,     -1.05345f,    0.363919f,    9.79707f,
    0.651223f,    0.699107f,    10.0173f,     -0.775721f,   0.0670376f,
    9.49062f,     0.296881f,    0.919373f,    10.1801f,     -0.68953f,
    -0.651223f,   9.70131f,     1.00556f,     0.248997f,    9.42358f,
    -0.995988f,   1.45567f,     9.13627f,     -1.35033f,    2.36547f,
    9.40442f,     0.976834f,    -4.34787f,    8.79151f,     -0.90022f,
    1.56102f,     8.92558f,     0.6608f,      -2.3942f,     9.59596f,
    -0.363919f,   1.40779f,     9.05966f,     0.181959f,    -2.1452f,
    9.48104f,     -0.612916f,   2.36547f,     9.03093f,     0.21069f,
    -2.18351f,    9.74919f,     -1.5706f,     2.07817f,     8.85855f,
    1.04387f,     -2.30801f,    8.81066f,     -1.66636f,    3.4285f,
    8.52336f,     0.440533f,    -4.52983f,    9.27993f,     -2.19309f,
    2.2697f,      8.83939f,     0.90022f,     -2.48039f,    9.1267f,
    -2.77727f,    1.4461f,      8.78193f,     0.814029f,    -4.24253f,
    8.90643f,     -3.39977f,    0.651223f,    8.86812f,     1.08218f,
    -2.34632f,    9.42358f,     -3.26569f,    0.402226f,    8.94474f,
    0.526724f,    -2.65278f,    9.38527f,     -3.21781f,    0.0f,
    9.20331f,     0.143652f,    -2.71024f,    9.44273f,     -2.8922f,
    -0.497994f,   9.35654f,     0.105345f,    -2.78685f,    9.09797f,
    -3.4285f,     -1.00556f,    8.81066f,     0.785298f,    -3.84988f,
    9.31823f,     -3.09331f,    -1.4461f,     8.68616f,     0.555455f,
    -3.27527f,    9.414f,       -2.5187f,     -1.79086f,    8.59997f,
    0.766145f,    -3.47638f,    9.0022f,      -2.67193f,    -2.43251f,
    8.77236f,     1.39821f,     -2.85389f,    8.25521f,     -3.29442f,
    -2.46124f,    8.15944f,     1.09176f,     -3.51469f,    8.72447f,
    -2.69108f,    -2.48997f,    8.91601f,     0.881066f,    -3.66792f,
    8.92558f,     -2.33674f,    -2.31759f,    8.84897f,     1.06303f,
    -3.055f,      8.92558f,     -2.49955f,    -2.29843f,    8.81066f,
    0.919373f,    -2.56658f,    9.31823f,     -2.78685f,    -1.81959f,
    9.06924f,     0.411803f,    -2.86347f,    9.38527f,     -2.78685f,
    -1.70467f,    9.25119f,     0.335188f,    -4.67348f,    9.165f,
    -3.9648f,     -0.622492f,   8.65743f,     0.248997f,    -3.055f,
    9.414f,       -3.67749f,    0.0287304f,   8.82982f,     0.852336f,
    -2.50912f,    8.82024f,     -3.47638f,    0.201113f,    8.98304f,
    1.06303f,     -3.33273f,    8.89685f,     -3.64876f,    0.718261f,
    8.91601f,     1.52271f,     -2.70066f,    8.95431f,     -3.56257f,
    1.35991f,     9.05008f,     1.67594f,     -3.16992f,    9.08839f,
    -3.16035f,    2.03028f,     9.07881f,     1.64721f,     -3.04542f,
    8.91601f,     -3.11246f,    2.52828f,     8.88728f,     2.07817f,
    -1.99198f,    9.1267f,      -2.806f,      0.162806f,    9.1267f,
    2.806f,       -2.07817f,    9.14585f,     -2.31759f,    2.16436f,
    8.8777f,      2.19309f,     -1.88663f,    9.88326f,     -2.5187f,
    1.94409f,     9.1267f,      2.46124f,     -2.806f,      7.64229f,
    -6.0717f,     2.9305f,      8.07325f,     5.64074f,     -2.63362f,
    4.29999f,     -7.9679f,     0.622492f,    4.71179f,     7.74764f,
    -3.41892f,    4.42448f,     -8.99262f,    1.13964f,     3.98395f,
    8.47547f,     -1.9824f,     -0.699107f,   -9.46189f,    -0.794875f,
    -0.593762f,   9.24162f,     -2.74854f,    1.88663f,     -8.8777f,
    -0.153229f,   0.861913f,    8.98304f,     -2.48039f,    -1.52271f,
    -9.32781f,    -3.39977f,    0.0574608f,   8.99262f,     -5.88974f,
    -0.746991f,   -3.93607f,    -8.01579f,    -1.17795f,    8.41801f,
    -4.17549f,    -2.30801f,    -2.61447f,    -9.44273f,    -2.3942f,
    7.46991f,     -5.01825f,    -1.0343f,     1.89621f,     -8.8777f,
    -0.890643f,   8.65743f,     -4.31914f,    -2.16436f,    1.49398f,
    -9.69173f,    -1.37906f,    9.05008f,     -2.43251f,    -1.87705f,
    0.402226f,    -8.95431f,    -2.01113f,    8.72447f,     -3.54342f,
    -0.344765f,   -2.95923f,    -8.42759f,    -0.92895f,    8.99262f,
    -2.34632f,    -0.392649f,   -6.70376f,    -6.55054f,    -0.919373f,
    8.80109f,     -2.35589f,    -0.0766145f,  -8.8777f,     -5.89931f,
    0.890643f,    9.7875f,      2.24097f,     -0.536301f,   -8.08282f,
    -4.88417f,    -0.191536f,   9.21289f,     1.16837f,     -0.440533f,
    -7.93917f,    -4.81713f,    -0.890643f,   9.08839f,     1.75256f,
    -1.20668f,    -9.414f,      -2.57616f,    -0.708684f,   9.50977f,
    1.40779f,     -1.14922f,    -9.8258f,     -1.24498f,    -0.584185f,
    9.63427f,     0.727837f,    -0.181959f,   -9.25119f,    -2.31759f,
    -0.0574608f,  9.64384f,     -0.612916f,   1.21625f,     -9.50977f,
    -1.16837f,    0.756568f,    9.45231f,     -0.316035f,   1.21625f,
    -10.5441f,    -0.45011f,    1.5706f,      9.7875f,      -1.22583f,
    9.07881f,     0.0766145f,   -2.34632f,    9.26077f,     0.316035f,
    4.28083f,     8.72447f,     0.584185f,    -3.27527f,    8.39886f,
    0.47884f,     3.98395f,     9.26077f,     2.35589f,     -2.98796f,
    9.52892f,     -1.61848f,    3.73495f,     8.91601f,     2.98796f,
    -3.36146f,    9.7875f,      -2.31759f,    3.60088f,     8.86812f,
    3.32315f,     -3.62961f,    9.76834f,     -2.46124f,    2.72939f,
    2.31759f,     10.2089f,     -2.3942f,     0.995988f,    -8.68616f,
    5.5737f,      1.13006f,     9.04051f,     -2.09732f,    1.26414f,
    -8.51378f,    4.40533f,     0.852336f,    9.91199f,     -2.07817f,
    0.622492f,    -9.18416f,    4.29999f,     0.229843f,    10.0269f,
    -1.08218f,    0.220267f,    -9.40442f,    4.40533f,     0.0766145f,
    9.54808f,     -1.89621f,    0.967257f,    -9.05966f,    3.92649f,
    0.335188f,    9.62469f,     -0.497994f,   0.430956f,    -9.71088f,
    4.02226f,     0.718261f,    9.63427f,     1.59933f,     0.383072f,
    -8.88728f,    3.24654f,     0.42138f,     8.71489f,     2.55701f,
    0.68953f,     -9.64384f,    1.67594f,     1.0726f,      -7.0198f,
    7.20176f,     0.641646f,    -9.17458f,    4.18506f,     -0.402226f,
    -2.46124f,    8.78193f,     -0.0383072f,  -8.31267f,    4.03184f,
    0.23942f,     2.27928f,     10.4675f,     -0.517148f,   -9.47146f,
    4.14676f,     -1.37906f,    9.59596f,     -4.07972f,    3.45723f,
    -9.663f,      1.71425f,     -0.134075f,   6.95276f,     -5.80354f,
    0.268151f,    -5.38217f,    7.03895f,     0.00957681f,  5.20978f,
    -7.75721f,    -0.047884f,   -2.83473f,    8.53294f,     -0.306458f,
    1.64721f,     -8.64786f,    0.766145f,    0.162806f,    8.84897f,
    -0.191536f,   -2.58574f,    -9.19373f,    0.0f,         4.05099f,
    8.52336f,     -0.0383072f,  -3.10289f,    -9.17458f,    0.45011f,
    4.11803f,     9.19373f,     0.0957681f,   -2.47082f,    -9.61511f,
    0.804452f,    3.98395f,     8.52336f,     0.114922f,    4.00311f,
    -8.76278f,    0.699107f,    4.53941f,     8.28394f,     -0.0383072f,
    7.95833f,     -6.57927f,    -0.124498f,   3.52426f,     10.1035f,
    -0.229843f,   6.68461f,     -6.2345f,     -0.153229f,   3.04542f,
    9.59596f,     -0.344765f,   7.47949f,     -7.29753f,    0.114922f,
    3.90734f,     9.03093f,     -0.383072f,   7.57525f,     -7.20176f,
    -0.172383f,   3.70622f,     9.8258f,      -0.335188f,   7.21134f,
    -6.7325f,     -0.172383f,   2.71024f,     10.2855f,     -0.114922f,
    6.608f,       -7.41245f,    -0.201113f,   1.87705f,     9.39485f,
    1.37906f,     -0.0670376f,  -9.47146f,    1.1971f,      1.8579f,
    9.49062f,     0.842759f,    -1.63763f,    -8.95431f,    0.679953f,
    2.8922f,      9.1267f,      1.43652f,     -1.58017f,    -9.01178f,
    0.890643f,    3.66792f,     9.22246f,     0.746991f,    -1.18752f,
    -9.04051f,    2.12605f,     2.72939f,     9.52892f,     3.79242f,
    1.48441f,     -9.04051f,    4.57771f,     -0.785298f,   9.61511f,
    4.61602f,     1.21625f,     -8.4659f,     4.94163f,     -0.574608f,
    8.4659f,      4.67348f,     1.48441f,     -8.23605f,    4.86502f,
    -0.852336f,   9.24162f,     5.12359f,     0.92895f,     -9.03093f,
    5.84185f,     -0.430956f,   8.92558f,     5.38217f,     0.440533f,
    -8.37971f,    6.72292f,     -0.220267f,   8.02536f,     6.608f,
    1.6089f,      -6.30154f,    6.33985f,     0.277727f,    6.58884f,
    9.85453f,     1.39821f,     0.153229f,    10.0844f,     -1.46525f,
    0.45011f,     9.68215f,     1.90578f,     -0.0766145f,  9.98861f,
    -1.96325f,    0.536301f,    9.90242f,     2.20267f,     0.143652f,
    9.94073f,     -2.20267f,    0.191536f,    9.46189f,     1.95367f,
    0.0957681f,   9.74919f,     -2.06859f,    0.296881f,    9.30866f,
    1.64721f,     0.153229f,    9.84496f,     -1.92494f,    0.574608f,
    7.38372f,     0.488417f,    6.76123f,     8.83939f,     -1.37906f,
    -3.11246f,    9.2895f,      0.153229f,    -0.976834f,   9.86411f,
    -0.0574608f,  -0.957681f,   9.26077f,     0.833182f,    2.07817f,
    9.26077f,     -0.938527f,   -0.957681f,   10.0269f,     -0.354342f,
    2.43251f,     9.84496f,     0.153229f,    -0.957681f,   0.986411f,
    -8.74362f,    1.34075f,     2.09732f,     9.165f,       -1.84832f,
    -1.25456f,    -10.228f,     2.19309f,     0.42138f,     9.73004f,
    -1.23541f,    -1.49398f,    -10.1706f,    0.172383f,    -1.22583f,
    10.2089f,     -0.593762f,   -2.2314f,     -9.663f,      -0.526724f,
    -1.6089f,     9.65342f,     0.593762f,    -2.38462f,    -9.165f,
    -1.4461f,     -2.46124f,    9.42358f,     0.430956f,    -2.38462f,
    -9.73004f,    0.0383072f,   -2.31759f,    9.57681f,     -0.47884f,
    -2.44209f,    -9.5385f,     -0.746991f,   -2.32716f,    9.58638f,
    0.612916f,    -2.34632f,    -10.1418f,    -1.0726f,     -1.92494f,
    9.90242f,     0.890643f,    -2.84431f,    9.38527f,     -2.38462f,
    -1.69509f,    -9.50977f,    2.73897f,     -3.88818f,    7.9296f,
    -2.40378f,    -1.5706f,     -8.4659f,     2.62405f,     -8.91601f,
    -2.98796f,    0.497994f,    -8.97347f,    2.79643f,     0.373495f,
    -10.3717f,    1.02472f,     -0.105345f,   -10.0461f,    -1.02472f,
    0.679953f,    -4.89375f,    8.17859f,     0.0766145f,   -6.12916f,
    -7.61356f,    0.172383f,    -6.4835f,     7.5561f,      -0.363919f,
    -6.09085f,    -7.46991f,    0.699107f,    -6.19619f,    7.62314f,
    -0.248997f,   -5.78439f,    -7.52737f,    1.55144f,     -6.33985f,
    7.50822f,     -0.45011f,    -5.6982f,     -7.48906f,    1.48441f,
    -6.36858f,    7.46991f,     -0.373495f,   -5.72693f,    -7.44118f,
    1.63763f,     -6.33027f,    7.8434f,      -0.316035f,   -6.54096f,
    -7.57525f,    1.37906f,     -6.69419f,    7.52737f,     -0.258574f,
    -6.41646f,    -7.37414f,    1.21625f,     -6.62715f,    7.61356f,
    -0.392649f,   -6.24408f,    -7.48906f,    1.23541f,     -6.18662f,
    7.60398f,     -0.201113f,   -5.9472f,     -7.45076f,    1.39821f,
    -6.14831f,    7.86256f,     -0.584185f,   -6.26323f,    -7.50822f,
    1.6089f,      -5.26724f,    8.74362f,     -0.153229f,   -4.57771f,
    -8.41801f,    0.6608f,      -3.56257f,    8.82024f,     0.114922f,
    -2.86347f,    -8.82982f,    0.948104f,    -2.53785f,    9.27035f,
    0.23942f,     -2.33674f,    -9.29908f,    1.02472f,     -2.12605f,
    9.67257f,     0.354342f,    -2.1452f,     -9.45231f,    0.335188f,
    -1.71425f,    9.36612f,     0.287304f,    -1.41737f,    -9.27035f,
    -0.229843f,   -2.65278f,    8.94474f,     -0.306458f,   -0.737414f,
    -9.414f,      0.172383f,    -8.72447f,    5.46836f,     0.325611f,
    -10.2663f,    -1.80044f,    -0.143652f,   -9.35654f,    -0.794875f,
    -0.756568f,   -10.1801f,    1.0343f,      1.20668f,     -9.54808f,
    -0.986411f,   -0.766145f,   -9.165f,      0.890643f,    1.13964f,
    -8.92558f,    -0.555455f,   -1.22583f,    -9.68215f,    0.976834f,
    0.344765f,    -9.14585f,    4.05099f,     -1.31202f,    -9.57681f,
    0.68953f,     1.51314f,     -9.54808f,    0.0957681f,   1.45567f,
    -9.18416f,    -0.229843f,   -0.6608f,     -9.71088f,    0.047884f,
    1.35033f,     -9.87369f,    0.0383072f,   -0.909797f,   -8.57124f,
    1.1971f,      3.86903f,     -9.76834f,    -1.13964f,    -2.2697f,
    -9.38527f,    0.890643f,    2.74854f,     -9.38527f,    -1.20668f,
    -2.3942f,     -8.74362f,    1.4461f,      3.45723f,     -8.99262f,
    -1.72383f,    -2.56658f,    -9.48104f,    1.13006f,     2.98796f,
    -8.80109f,    -1.76213f,    -2.52828f,    -9.69173f,    1.15879f,
    2.3942f,      -8.98304f,    -1.68552f,    -1.71425f,    -8.93516f,
    1.25456f,     3.26569f,     -9.61511f,    -1.38864f,    -2.46124f,
    -9.37569f,    1.4461f,      3.40934f,     -8.83939f,    -2.1069f,
    -2.42293f,    -9.165f,      1.61848f,     2.9305f,      -9.165f,
    -2.04944f,    -2.50912f,    -9.31823f,    0.823605f,    0.0f,
    -9.48104f,    -0.909797f,   0.497994f,    -9.30866f,    1.0343f,
    -0.775721f,   -9.01178f,    -1.15879f,    0.814029f,    -9.25119f,
    0.948104f,    -0.00957681f, -8.80109f,    -1.16837f,    0.737414f,
    -9.62469f,    1.39821f,     -0.248997f,   -9.39485f,    -1.45567f,
    0.957681f,    -9.57681f,    1.79086f,     -0.296881f,   -9.50019f,
    -1.81002f,    0.842759f,    -10.0652f,    1.45567f,     -0.248997f,
    -9.05966f,    -1.61848f,    0.871489f,    -9.69173f,    1.56102f,
    -0.459687f,   -8.91601f,    -1.77171f,    0.890643f,    -9.48104f,
    -0.47884f,    -0.497994f,   -9.48104f,    0.296881f,    0.632069f,
    -10.094f,     0.191536f,    -0.248997f,   -10.4387f,    -0.0670376f,
    0.6608f,      -8.08282f,    4.95121f,     -1.31202f,    -8.17859f,
    -4.70221f,    1.80044f,     -7.9296f,     5.04698f,     -0.536301f,
    -8.38928f,    -4.80756f,    0.68953f,     -8.10198f,    5.23851f,
    -0.507571f,   -7.97748f,    -5.17148f,    1.21625f,     -8.37013f,
    5.22894f,     -0.497994f,   -8.01579f,    -5.23851f,    0.976834f,
    -8.20732f,    5.20978f,     -0.335188f,   -7.99663f,    -5.19063f,
    0.995988f,    -8.26478f,    5.02782f,     -0.0957681f,  -8.0924f,
    -5.0374f,     0.948104f,    -8.36055f,    5.02782f,     -0.268151f,
    -8.02536f,    -5.09486f,    0.995988f,    -8.28394f,    5.01825f,
    -0.191536f,   -8.20732f,    -5.06613f,    0.861913f,    -8.37971f,
    5.06613f,     -0.325611f,   -8.20732f,    -5.00867f,    0.92895f,
    -8.3414f,     5.04698f,     -0.124498f,   -8.13071f,    -5.14275f,
    0.852336f,    -8.29351f,    5.07571f,     -0.0766145f,  -8.07325f,
    -5.10444f,    0.976834f,    -8.47547f,    4.77883f,     -0.392649f,
    -8.13071f,    -4.86502f,    1.05345f,     -8.60955f,    2.71981f,
    2.79643f,     -9.25119f,    1.31202f,     -0.306458f,   -9.14585f,
    1.02472f,     1.51314f,     -8.64786f,    -1.33118f,    -1.13964f,
    -9.35654f,    1.01514f,     2.31759f,     -8.72447f,    -1.49398f,
    -1.72383f,    -9.73004f,    1.58017f,     2.7677f,      -9.73004f,
    -1.84832f,    -1.93451f,    -9.15543f,    1.33118f,     2.20267f,
    -8.93516f,    -1.64721f,    -0.995988f,   -9.45231f,    0.727837f,
    1.81959f,     -9.51935f,    -0.909797f,   -2.78685f,    -9.93115f,
    0.191536f,    0.890643f,    -9.84496f,    -0.23942f,    -0.976834f,
    -9.61511f,    -0.21069f,    0.517148f,    -8.80109f,    -0.153229f,
    -0.430956f,   -9.50019f,    0.373495f,    0.948104f,    -9.27035f,
    -0.555455f,   -0.344765f,   -9.57681f,    0.172383f,    0.881066f,
    -9.43316f,    -0.335188f,   -0.756568f,   -9.50977f,    -0.0191536f,
    0.497994f,    -9.42358f,    -0.181959f,   -0.737414f,   -9.92157f,
    0.306458f,    0.545878f,    -10.0173f,    -0.248997f,   -0.134075f,
    -9.79707f,    0.0287304f,   0.536301f,    -9.71088f,    -0.162806f,
    -0.181959f,   -9.60554f,    -0.047884f,   0.804452f,    -9.39485f,
    -0.181959f,   -0.593762f,   -9.64384f,    -0.047884f,   0.612916f,
    -9.58638f,    -0.201113f,   -0.363919f,   -9.56723f,    0.248997f,
    0.411803f,    -10.1706f,    -0.316035f,   -0.526724f,   -9.63427f,
    0.459687f,    1.09176f,     -9.71088f,    -0.603339f,   -0.23942f,
    -9.62469f,    -0.0383072f,  0.68953f,     -9.50019f,    -0.0861913f,
    -1.13006f,    -9.80665f,    -0.134075f,   0.335188f,    -9.40442f,
    -0.114922f,   -0.354342f,   -9.34696f,    0.153229f,    1.54187f,
    -9.10754f,    -0.526724f,   -1.00556f,    -9.7875f,     0.0287304f,
    0.775721f,    -9.58638f,    -0.172383f,   -0.641646f,   -9.60554f,
    0.258574f,    0.919373f,    -9.31823f,    -0.402226f,   -0.603339f,
    -9.5385f,     -0.0766145f,  0.92895f,     -9.09797f,    -0.220267f,
    -0.354342f,   -9.61511f,    -0.335188f,   0.316035f,    -9.27993f,
    0.0766145f,   -0.47884f,    -9.40442f,    0.23942f,     0.6608f,
    -9.40442f,    -0.335188f,   -0.603339f,   -9.85453f,    -0.0766145f,
    0.459687f,    -9.54808f,    -0.0670376f,  -0.287304f,   -9.63427f,
    -0.344765f,   0.296881f,    -9.32781f,    0.0574608f,   -0.220267f,
    -9.71088f,    0.181959f,    0.354342f,    -9.95988f,    -0.248997f,
    0.201113f,    -9.8258f,     -0.0383072f,  0.833182f,    -9.83538f,
    -0.047884f,   -0.670376f,   -9.44273f,    0.0670376f,   0.6608f,
    -8.90643f,    -0.392649f,   -0.354342f,   -9.54808f,    0.0957681f,
    0.90022f,     -9.05008f,    -0.411803f,   -0.335188f,   -9.52892f,
    0.201113f,    1.12049f,     -9.23204f,    -0.459687f,   -0.842759f,
    -9.61511f,    -0.162806f,   0.248997f,    -9.87369f,    0.124498f,
    -1.12049f,    -9.70131f,    -0.0383072f,  0.670376f,    -9.50977f,
    -0.162806f,   -0.890643f,   -9.15543f,    0.488417f,    1.51314f,
    -8.94474f,    -0.852336f,   -0.90022f,    -9.60554f,    -0.23942f,
    0.622492f,    -9.35654f,    0.0f,         -0.948104f,   -9.64384f,
    -0.191536f,   1.21625f,     -9.2895f,     -0.0766145f,  -0.785298f,
    -9.55765f,    -0.306458f,   0.555455f,    -9.73004f,    0.172383f,
    -0.603339f,   -9.663f,      -0.306458f,   0.383072f,    -9.63427f,
    0.172383f,    -0.354342f,   -9.70131f,    -0.373495f,   0.68953f,
    -9.69173f,    0.181959f,    -1.0343f,     -9.47146f,    -0.526724f,
    0.823605f,    -9.23204f,    0.220267f,    -1.36948f,    -9.36612f,
    -0.0670376f,  1.05345f,     -8.91601f,    -0.316035f,   -0.814029f,
    -9.93115f,    -0.268151f,   1.58017f,     -10.0748f,    0.143652f,
    -1.26414f,    -9.87369f,    0.047884f,    2.09732f,     -9.39485f,
    -0.344765f,   -1.48441f,    -9.48104f,    0.967257f,    0.699107f,
    -9.34696f,    -1.15879f,    -0.105345f,   -9.414f,      0.852336f,
    0.756568f,    -9.62469f,    -1.0343f,     -0.114922f,   -9.80665f,
    0.814029f,    0.737414f,    -9.23204f,    -1.0726f,     -0.23942f,
    -9.47146f,    0.890643f,    0.392649f,    -9.24162f,    -1.08218f,
    -0.229843f,   -9.42358f,    0.775721f,    0.325611f,    -9.21289f,
    -0.986411f,   -0.201113f,   -9.52892f,    1.79086f,     2.04944f,
    -9.32781f,    -2.15478f,    -1.39821f,    -8.86812f,    2.07817f,
    2.2697f,      -8.91601f,    -2.24097f,    -1.7334f,     -9.34696f,
    1.68552f,     2.29843f,     -8.78193f,    -2.19309f,    -1.58017f,
    -9.62469f,    1.7334f,      2.35589f,     -9.165f,      -2.18351f,
    -1.63763f,    -9.99819f,    2.28886f,     2.27928f,     -10.0365f,
    -2.36547f,    -1.69509f,    -10.726f,     -0.488417f,   -0.363919f,
    -9.25119f,    0.976834f,    -3.03585f,    -9.31823f,    1.41737f,
    2.09732f,     -8.8777f,     -1.76213f,    0.651223f,    -9.71088f,
    1.00556f,     2.28886f,     -9.36612f,    -1.13006f,    -1.53229f,
    -9.87369f,    0.814029f,    1.46525f,     -9.92157f,    -0.919373f,
    -0.957681f,   -9.35654f,    0.0191536f,   1.09176f,     -9.9503f,
    -0.0574608f,  -1.0726f,     -9.50977f,    -0.181959f,   0.603339f,
    -8.90643f,    -0.172383f,   -0.0766145f,  -9.85453f,    -0.287304f,
    0.833182f,    -9.76834f,    0.181959f,    -0.402226f,   -9.50977f,
    -0.0957681f,  0.287304f,    -9.7875f,     0.0191536f,   -0.47884f,
    -9.58638f,    0.047884f,    0.344765f,    -9.44273f,    -0.181959f,
    -0.0861913f,  -9.57681f,    0.0287304f,   0.555455f,    -9.42358f,
    -0.220267f,   0.0f,         -9.73004f,    -0.229843f,   0.21069f,
    -9.51935f,    0.0670376f,   -0.21069f,    -10.0173f,    -0.00957681f,
    0.105345f,    -9.68215f,    -0.0670376f,  -0.124498f,   -9.50977f,
    0.114922f,    0.287304f,    -9.42358f,    -0.229843f,   0.0957681f,
    -9.57681f,    -0.181959f,   0.181959f,    -9.32781f,    -0.047884f,
    0.105345f,    -10.0078f,    -0.258574f,   -2.19309f,    -9.70131f,
    0.248997f,    1.64721f,     -9.55765f,    -0.612916f,   0.105345f,
    -8.76278f,    0.191536f,    0.919373f,    -9.414f,      -0.0383072f,
    -0.641646f,   -9.74919f,    0.0670376f,   0.814029f,    -9.80665f,
    -0.134075f,   -0.804452f,   -9.44273f,    0.0957681f,   1.01514f,
    -9.71088f,    0.220267f,    -0.584185f,   -9.32781f,    -0.248997f,
    0.957681f,    -9.76834f,    0.0766145f,   -0.440533f,   -9.414f,
    -0.21069f,    0.708684f,    -9.73004f,    0.0574608f,   -0.593762f,
    -9.27035f,    -0.172383f,   0.756568f,    -9.663f,      0.287304f,
    0.172383f,    -9.10754f,    -0.507571f,   0.718261f,    -9.49062f,
    0.229843f,    0.0574608f,   -9.50977f,    -0.402226f,   0.162806f,
    -10.1418f,    -0.0670376f,  -0.411803f,   -9.32781f,    -0.0383072f,
    0.804452f,    -9.57681f,    0.229843f,    -0.21069f,    -9.57681f,
    -0.296881f,   0.469264f,    -9.54808f,    2.03986f,     0.641646f,
    -10.0269f,    -1.00556f,    -0.45011f,    -8.77236f,    0.402226f,
    0.718261f,    -9.37569f,    -0.047884f,   -0.344765f,   -9.98861f,
    -1.48441f,    0.047884f,    -9.33739f,    1.33118f,     -0.23942f,
    -9.30866f,    -0.68953f,    0.220267f,    -10.0556f,    0.708684f,
    0.201113f,    -7.12514f,    6.70376f,     0.105345f,    -6.81869f,
    -6.33985f,    0.92895f,     -8.70532f,    5.46836f,     0.220267f,
    -8.41801f,    -5.36301f,    0.0574608f,   -9.84496f,    3.82115f,
    0.248997f,    -9.9503f,     -3.5913f,     -0.229843f,   -10.3238f,
    3.09331f,     -0.0574608f,  -9.71088f,    -2.66235f,    0.6608f,
    -8.68616f,    1.53229f,     0.641646f,    -9.17458f,    -1.22583f,
    0.507571f,    -10.0078f,    -1.09176f,    -0.622492f,   -10.0078f,
    1.3216f,      -0.497994f,   -9.46189f,    -1.17795f,    0.0766145f,
    -9.23204f,    1.01514f,     0.248997f,    -9.38527f,    -1.94409f,
    0.296881f,    -9.21289f,    1.79086f,     -0.21069f,    -9.10754f,
    -2.12605f,    0.440533f,    -9.09797f,    1.82917f,     0.172383f,
    -9.02135f,    -1.54187f,    0.047884f,    -9.35654f,    1.54187f,
    0.047884f,    -8.99262f,    -1.66636f,    -0.0191536f,  -9.29908f,
    1.49398f,     0.344765f,    -9.663f,      -1.65679f,    -0.593762f,
    -9.29908f,    1.58975f,     0.296881f,    -9.69173f,    -1.1971f,
    -0.153229f,   -9.5385f,     1.16837f,     0.114922f,    -9.80665f,
    -1.22583f,    0.268151f,    -9.43316f,    1.08218f,     -0.114922f,
    -9.74919f,    -1.27372f,    0.775721f,    -9.38527f,    1.11091f,
    -0.440533f,   -9.49062f,    -1.20668f,    0.574608f,    -9.37569f,
    0.995988f,    -0.536301f,   -9.33739f,    -1.06303f,    0.871489f,
    -9.5385f,     0.948104f,    -0.699107f,   -9.44273f,    -0.976834f,
    0.871489f,    -9.72046f,    0.890643f,    -0.746991f,   -9.87369f,
    -1.33118f,    0.488417f,    -9.46189f,    1.13006f,     0.248997f,
    -8.92558f,    -1.0343f,     -0.134075f,   -9.07881f,    1.04387f,
    0.737414f,    -8.82982f,    -0.814029f,   -1.46525f,    -9.20331f,
    1.06303f,     0.105345f,    -9.94073f,    -0.957681f,   -0.153229f,
    -9.35654f,    0.948104f,    -0.603339f,   -9.31823f,    1.34075f,
    2.03028f,     -8.82024f,    -1.76213f,    -0.861913f,   -8.42759f,
    -0.440533f,   4.67348f,     -8.94474f,    0.201113f,    -5.08528f,
    -7.51779f,    -0.948104f,   5.77481f,     -8.15944f,    0.833182f,
    -5.63116f,    -9.69173f,    -0.948104f,   2.36547f,     -10.1801f,
    0.679953f,    -2.2314f,     -9.11712f,    1.72383f,     0.574608f,
    -8.83939f,    -2.03986f,    -0.0287304f,  -9.31823f,    1.92494f,
    0.804452f,    -9.79707f,    -2.03028f,    -0.517148f,   -8.3414f,
    2.68151f,     1.9824f,      -8.24563f,    -2.71024f,    -2.1069f,
    -9.15543f,    2.41336f,     2.28886f,     -7.49864f,    -3.03585f,
    -3.66792f,    -8.59997f,    2.00155f,     2.59531f,     -9.07881f,
    -2.11647f,    -2.52828f,    -9.64384f,    1.89621f,     2.11647f,
    -9.36612f,    -2.16436f,    -1.83875f,    -9.01178f,    1.69509f,
    2.19309f,     -9.17458f,    -1.94409f,    -1.56102f,    -9.27993f,
    1.49398f,     2.28886f,     -9.51935f,    -1.72383f,    -2.2697f,
    -9.10754f,    1.52271f,     2.43251f,     -8.84897f,    -2.02071f,
    -2.02071f,    -9.08839f,    1.51314f,     2.55701f,     -9.11712f,
    -1.8579f,     -2.21224f,    -9.09797f,    1.47483f,     2.52828f,
    -9.13627f,    -1.8579f,     -2.09732f,    -9.06924f,    1.46525f,
    2.43251f,     -8.92558f,    -1.90578f,    -2.09732f,    -9.19373f,
    1.50356f,     2.3942f,      -9.21289f,    -1.82917f,    -2.26013f,
    -8.5904f,     2.16436f,     2.33674f,     -8.51378f,    -2.36547f,
    -1.83875f,    -8.25521f,    3.62961f,     2.03028f,     -7.91044f,
    -3.74453f,    -1.12049f,    -8.61913f,    3.84988f,     1.62806f,
    -8.83939f,    -3.97437f,    -1.26414f,    -8.23605f,    4.52025f,
    2.13563f,     -8.83939f,    -4.35745f,    -1.14922f,    -7.4316f,
    6.02381f,     2.34632f,     -7.33583f,    -5.84185f,    -1.79086f,
    -6.63673f,    6.67503f,     2.37505f,     -6.44519f,    -6.359f,
    -1.62806f,    -6.06212f,    7.51779f,     2.38462f,     -6.25365f,
    -7.23049f,    -1.80044f,    -5.25767f,    8.64786f,     2.09732f,
    -4.32872f,    -8.68616f,    -2.03986f,    -4.39575f,    7.97748f,
    2.00155f,     -3.77326f,    -8.42759f,    -0.775721f,   -4.64475f,
    8.32224f,     1.61848f,     -4.29999f,    -8.60955f,    -0.622492f,
    -4.7501f,     8.5042f,      1.81959f,     -4.79798f,    -8.4659f,
    -1.08218f,    -4.64475f,    8.37013f,     1.92494f,     -4.53941f,
    -8.5904f,     -1.13964f,    -4.77883f,    8.73405f,     2.11647f,
    -3.33273f,    -9.414f,      -1.37906f,    -9.73004f,    -0.92895f,
    0.603339f,    -9.67257f,    0.852336f,    -1.11091f,    -9.87369f,
    -0.047884f,   0.153229f,    -9.98861f,    0.0670376f,   -0.440533f,
    -9.61511f,    0.651223f,    0.181959f,    -9.5385f,     -0.785298f,
    0.612916f,    -9.50019f,    0.335188f,    -0.23942f,    -8.88728f,
    -0.536301f,   0.00957681f,  -9.95988f,    0.670376f,    0.134075f,
    -9.29908f,    -0.881066f,   0.0861913f,   -9.67257f,    0.488417f,
    0.220267f,    -9.62469f,    -0.545878f,   0.306458f,    -9.58638f,
    0.344765f,    0.306458f,    -9.165f,      -0.574608f,   0.0287304f,
    -9.65342f,    0.143652f,    0.287304f,    -10.0844f,    -0.191536f,
    0.440533f,    -9.40442f,    0.679953f,    0.21069f,     -9.37569f,
    -0.881066f,   0.402226f,    -9.79707f,    1.34075f,     0.785298f,
    -10.1801f,    -1.13964f,    -0.220267f,   -9.14585f,    2.29843f,
    0.794875f,    -9.36612f,    -2.24097f,    -0.316035f,   -8.83939f,
    3.37104f,     0.727837f,    -8.70532f,    -3.25611f,    0.0766145f,
    -8.24563f,    4.42448f,     0.814029f,    -8.14029f,    -4.27126f,
    -0.392649f,   -7.63272f,    5.38217f,     0.957681f,    -7.05811f,
    -5.5737f,     -0.0383072f,  -7.57525f,    5.93762f,     1.29287f,
    -7.02938f,    -6.02381f,    -0.651223f,   -7.46991f,    6.18662f,
    1.76213f,     -7.35499f,    -6.21535f,    -1.37906f,    -7.35499f,
    6.38773f,     1.47483f,     -7.40287f,    -6.27281f,    -0.967257f,
    -7.02938f,    6.79953f,     1.30245f,     -6.95276f,    -6.68461f,
    -0.890643f,   -6.42604f,    7.32626f,     1.09176f,     -6.4835f,
    -7.19218f,    -0.354342f,   -6.41646f,    7.57525f,     0.938527f,
    -6.11958f,    -7.50822f,    -0.229843f,   -5.88016f,    7.71891f,
    0.794875f,    -5.17148f,    -7.70933f,    0.105345f,    -5.74608f,
    7.85298f,     0.727837f,    -5.09486f,    -7.72848f,    0.114922f,
    -5.9472f,     7.83383f,     0.727837f,    -5.91847f,    -7.65187f,
    -0.0287304f,  -5.97593f,    7.77637f,     0.718261f,    -6.01423f,
    -7.63272f,    0.191536f,    -5.95677f,    7.78594f,     0.526724f,
    -5.73651f,    -7.6806f,     0.507571f,    -5.95677f,    7.89129f,
    0.459687f,    -5.66947f,    -7.74764f,    0.517148f,    -5.93762f,
    7.85298f,     0.430956f,    -5.81312f,    -7.69018f,    0.459687f,
    -5.9855f,     7.78594f,     0.469264f,    -5.86101f,    -7.65187f,
    0.517148f,    -6.03339f,    7.82425f,     0.411803f,    -5.75566f,
    -7.67102f,    0.526724f,    -6.00466f,    7.79552f,     0.402226f,
    -5.68862f,    -7.67102f,    0.42138f,     -6.00466f,    7.79552f,
    0.497994f,    -5.60243f,    -7.69975f,    0.201113f,    -6.13873f,
    7.65187f,     0.42138f,     -5.3247f,     -7.62314f,    0.172383f,
    -6.608f,      7.40287f,     0.258574f,    -5.77481f,    -7.46991f,
    0.593762f,    -7.18261f,    6.82826f,     0.134075f,    -6.75165f,
    -6.71334f,    0.526724f,    -7.88171f,    5.79397f,     -0.181959f,
    -7.19218f,    -5.70778f,    1.54187f,     -8.4659f,     4.54898f,
    -0.842759f,   -7.90087f,    -4.30956f,    1.95367f,     -10.5728f,
    0.632069f,    -1.96325f,    -9.84496f,    0.153229f,    1.82917f,
    -9.27993f,    -0.0861913f,  -0.92895f,    -9.31823f,    0.047884f,
    1.46525f,     -9.93115f,    0.325611f,    -1.1971f,     -10.2759f,
    -0.114922f,   2.3942f,      -9.59596f,    -0.0766145f,  -0.316035f,
    -9.97903f,    0.363919f,    -1.13964f,    -9.04051f,    2.50912f,
    1.31202f,     -8.67659f,    -2.58574f,    -0.603339f,   -9.83538f,
    1.00556f,     1.40779f,     -9.09797f,    -0.92895f,    -0.948104f,
    -9.165f,      0.699107f,    1.24498f,     -8.8777f,     -0.517148f,
    -0.699107f,   -9.57681f,    0.507571f,    0.641646f,    -9.65342f,
    -0.229843f,   -0.565032f,   -9.55765f,    0.287304f,    0.47884f,
    -8.91601f,    -0.201113f,   -0.833182f,   -9.69173f,    0.134075f,
    0.411803f,    -9.47146f,    0.162806f,    0.172383f,    -9.5385f,
    -0.21069f,    0.143652f,    -9.30866f,    0.497994f,    -0.105345f,
    -9.8258f,     0.507571f,    0.507571f,    -9.50977f,    -0.248997f,
    0.383072f,    -9.60554f,    0.641646f,    0.948104f,    -9.27993f,
    -0.220267f,   -0.0766145f,  -10.0844f,    0.430956f,    0.986411f,
    -9.52892f,    -0.00957681f, 0.517148f,    -9.02135f,    0.411803f,
    1.43652f,     -9.42358f,    -0.00957681f, -0.258574f,   -9.27035f,
    1.54187f,     0.45011f,     -9.84496f,    -0.995988f,   0.316035f,
    -9.8258f,     -0.402226f,   0.842759f,    -8.93516f,    0.967257f,
    -0.785298f,   -8.94474f,    2.63362f,     0.545878f,    -9.25119f,
    -2.78685f,    0.0383072f,   -7.71891f,    5.74608f,     0.909797f,
    -9.34696f,    -5.07571f,    -0.651223f,   -8.63828f,    4.58729f,
    0.430956f,    -8.69574f,    -4.29041f,    -1.16837f,    -7.39329f,
    7.83383f,     0.612916f,    -7.62314f,    -7.28795f,    -0.229843f,
    -6.17704f,    7.59441f,     1.89621f,     -5.58328f,    -7.56568f,
    0.153229f,    -5.53539f,    8.00621f,     0.967257f,    -4.83629f,
    -7.9679f,     0.411803f,    -4.95121f,    8.04452f,     0.248997f,
    -4.46279f,    -8.20732f,    0.201113f,    -4.99909f,    8.42759f,
    0.105345f,    -4.89375f,    -8.30309f,    -0.0287304f,  -4.52983f,
    8.5042f,      0.306458f,    -4.72137f,    -8.5042f,     0.0f,
    -4.36702f,    8.72447f,     0.0f,         -4.43406f,    -8.68616f,
    0.181959f,    -4.15633f,    8.8777f,      0.430956f,    -3.98395f,
    -9.02135f,    0.584185f,    -4.14676f,    8.68616f,     0.0670376f,
    -3.9648f,     -8.85855f,    1.09176f,     -4.18506f,    8.84897f,
    -0.114922f,   -4.35745f,    -8.77236f,    0.248997f,    -4.22337f,
    8.07325f,     0.325611f,    -3.67749f,    -8.5042f,     1.37906f,
    -9.15543f,    3.87861f,     2.11647f,     -9.27993f,    -2.25055f,
    -1.5706f,     -9.31823f,    0.0670376f,   1.47483f,     -10.1897f,
    -0.0766145f,  -0.354342f,   -9.24162f,    -0.162806f,   0.0670376f,
    -9.81623f,    0.325611f,    -1.0343f,     -5.88016f,    7.79552f,
    1.65679f,     -8.16902f,    -5.56412f,    -2.83473f,    -8.38928f,
    4.31914f,     1.39821f,     -8.81066f,    -4.41491f,    -1.08218f,
    -8.82982f,    4.46279f,     0.986411f,    -8.61913f,    -4.73094f,
    -0.727837f,   -8.06367f,    3.85945f,     1.38864f,     -8.16902f,
    -3.98395f,    -0.766145f,   -8.73405f,    3.92649f,     1.63763f,
    -8.71489f,    -4.10845f,    -1.61848f,    -8.91601f,    3.36146f,
    2.04944f,     -9.08839f,    -3.47638f,    -1.97282f,    -8.82024f,
    3.40934f,     2.29843f,     -8.83939f,    -3.66792f,    -2.24097f,
    -8.88728f,    3.553f,       2.17394f,     -8.84897f,    -3.78284f,
    -2.21224f,    -8.73405f,    4.01268f,     2.21224f,     -8.74362f,
    -4.22337f,    -2.07817f,    -8.63828f,    3.90734f,     2.20267f,
    -8.97347f,    -3.77326f,    -1.87705f,    -8.39886f,    4.48195f,
    2.08774f,     -9.06924f,    -4.30956f,    -1.71425f,    -7.44118f,
    6.41646f,     1.83875f,     -7.72848f,    -6.76123f,    -1.05345f,
    -6.08127f,    7.51779f,     1.35991f,     -4.92248f,    -7.63272f,
    0.0766145f,   -6.33027f,    7.44118f,     1.49398f,     -6.03339f,
    -7.42203f,    -0.430956f,   -6.13873f,    7.53695f,     1.42694f,
    -6.27281f,    -7.45076f,    -0.90022f,    -6.17704f,    7.54652f,
    1.37906f,     -6.14831f,    -7.51779f,    -0.42138f,    -6.06212f,
    7.56568f,     1.47483f,     -6.2345f,     -7.46033f,    -0.316035f,
    -6.02381f,    7.67102f,     1.49398f,     -6.22492f,    -7.50822f,
    -0.497994f,   -5.67905f,    7.85298f,     1.71425f,     -6.03339f,
    -7.57525f,    -1.05345f,    -5.06613f,    8.05409f,     1.83875f,
    -4.82671f,    -7.97748f,    -0.565032f,   -4.54898f,    8.23605f,
    1.99198f,     -4.42448f,    -8.42759f,    -1.06303f,    -4.24253f,
    8.7532f,      2.17394f,     -4.40533f,    -8.81066f,    -2.05901f,
    -3.44765f,    9.10754f,     1.92494f,     -3.01669f,    -9.39485f,
    -0.68953f,    -3.055f,      8.68616f,     2.11647f,     -3.4285f,
    -8.73405f,    -1.3216f,     -2.72939f,    8.88728f,     2.11647f,
    -2.61447f,    -9.02135f,    -1.21625f,    -2.55701f,    9.38527f,
    2.30801f,     -2.15478f,    -9.663f,      -2.33674f,    -2.48039f,
    9.23204f,     2.2314f,      -1.53229f,    -9.71088f,    -1.13964f,
    -3.66792f,    8.72447f,     2.24097f,     -2.29843f,    -8.88728f,
    -2.31759f,    -8.54251f,    3.89776f,     1.75256f,     -9.05966f,
    -2.90177f,    -2.06859f,    -9.29908f,    2.04944f,     1.6089f,
    -9.86411f,    -1.71425f,    -1.16837f,    -10.2855f,    1.29287f,
    0.766145f,    -10.1993f,    -1.1971f,     -0.373495f,   -9.89284f,
    1.1971f,      0.995988f,    -9.14585f,    -1.48441f,    -0.201113f,
    -9.43316f,    0.306458f,    1.45567f,     -9.19373f,    -0.6608f,
    -0.727837f,   -9.15543f,    -0.0287304f,  0.047884f,    -9.40442f,
    0.0287304f,   0.392649f,    -9.9503f,     -0.948104f,   0.0287304f,
    -10.1323f,    1.06303f,     -0.47884f,    -10.0078f,    -0.45011f,
    0.23942f,     -9.52892f,    0.287304f,    -0.191536f,   -9.45231f,
    -0.545878f,   0.42138f,     -9.52892f,    0.354342f,    -0.584185f,
    -9.86411f,    -0.258574f,   0.699107f,    -9.44273f,    0.0f,
    -0.42138f,    -8.4659f,     3.95522f,     0.354342f,    -8.57124f,
    -4.1276f,     0.430956f,    -8.71489f,    4.04141f,     0.306458f,
    -8.95431f,    -3.9648f,     -0.603339f,   -8.89685f,    3.58173f,
    0.354342f,    -8.52336f,    -3.85945f,    0.258574f,    -9.35654f,
    3.54342f,     -0.785298f,   -9.02135f,    -3.69665f,    0.92895f,
    -8.76278f,    2.84431f,     -1.17795f,    -8.56167f,    -2.806f,
    2.07817f,     -8.89685f,    3.13162f,     -1.49398f,    -8.5042f,
    -3.16035f,    2.03028f,     -9.09797f,    4.00311f,     -0.995988f,
    -9.71088f,    -3.79242f,    2.70066f,     -9.04051f,    3.58173f,
    -1.01514f,    -8.04452f,    -3.64876f,    1.81002f,     -7.86256f,
    4.94163f,     -0.201113f,   -7.46991f,    -5.02782f,    1.81959f,
    -7.41245f,    6.46434f,     -0.47884f,    -7.44118f,    -6.31112f,
    0.976834f,    -6.57927f,    6.68461f,     -0.114922f,   -6.36858f,
    -6.40688f,    2.35589f,     -6.02381f,    7.31668f,     -0.469264f,
    -5.43005f,    -7.24007f,    2.43251f,     -6.87615f,    7.48906f,
    -0.536301f,   -7.03895f,    -7.15387f,    0.90022f,     -5.9855f,
    7.72848f,     -0.201113f,   -5.78439f,    -7.47949f,    1.13964f,
    -6.06212f,    7.9296f,      -0.268151f,   -5.25767f,    -7.76679f,
    1.63763f,     -5.70778f,    8.29351f,     -0.162806f,   -4.72137f,
    -8.14029f,    1.20668f,     -5.29597f,    8.42759f,     0.143652f,
    -4.75967f,    -8.42759f,    0.603339f,    -5.11401f,    8.44674f,
    0.565032f,    -4.85544f,    -8.43717f,    -0.00957681f, -5.43963f,
    8.23605f,     0.919373f,    -5.1619f,     -8.05409f,    -0.325611f,
    -5.60243f,    8.0924f,      0.718261f,    -5.48751f,    -7.86256f,
    -0.047884f,   -5.84185f,    7.98706f,     1.11091f,     -5.58328f,
    -7.91044f,    0.162806f,    -5.79397f,    7.8434f,      1.16837f,
    -5.47793f,    -7.69975f,    -0.392649f,   -5.78439f,    7.77637f,
    1.36948f,     -5.63116f,    -7.61356f,    -0.651223f,   -5.95677f,
    7.73806f,     1.55144f,     -5.19063f,    -7.69975f,    -0.833182f,
    -6.22492f,    7.5561f,      1.49398f,     -5.46836f,    -7.53695f,
    -0.833182f,   -6.87615f,    6.98149f,     1.25456f,     -6.53138f,
    -6.82826f,    -0.871489f,   -7.40287f,    6.03339f,     0.6608f,
    -6.67503f,    -5.9855f,     0.344765f,    -8.00621f,    4.66391f,
    0.574608f,    -7.71891f,    -4.67348f,    0.641646f,    -9.48104f,
    2.24097f,     1.0343f,      -9.77792f,    -2.03028f,    -0.995988f,
    -9.76834f,    1.30245f,     1.05345f,     -9.72046f,    -1.25456f,
    -0.593762f,   -9.47146f,    0.507571f,    1.1971f,      -10.4675f,
    -0.459687f,   -0.804452f,   -9.67257f,    0.201113f,    1.15879f,
    -9.60554f,    -0.383072f,   -1.13006f,    -9.42358f,    -0.0191536f,
    1.08218f,     -10.0844f,    -0.0574608f,  -0.823605f,   -7.12514f,
    6.99107f,     -0.488417f,   -7.20176f,    -6.6463f,     1.63763f,
    -7.16345f,    6.86657f,     -0.430956f,   -7.46991f,    -6.47392f,
    0.823605f,    -7.09641f,    7.1443f,      -0.804452f,   -6.6463f,
    -7.00065f,    1.76213f,     -7.50822f,    6.62715f,     -0.277727f,
    -5.86101f,    -7.06768f,    0.986411f,    -7.2688f,     7.23049f,
    -0.47884f,    -7.28795f,    -6.97192f,    1.51314f,     -7.37414f,
    6.62715f,     -0.287304f,   -7.24964f,    -6.39731f,    0.995988f,
    -7.40287f,    6.56969f,     -0.392649f,   -7.11557f,    -6.44519f,
    1.14922f,     -7.3071f,     6.8953f,      -0.584185f,   -6.56011f,
    -6.91445f,    1.78129f,     -7.51779f,    6.78038f,     -0.612916f,
    -5.74608f,    -7.02938f,    3.48596f,     -7.24007f,    6.33985f,
    -0.325611f,   -6.8953f,     -6.03339f,    0.536301f,    -8.99262f,
    5.01825f,     -0.258574f,   -9.73961f,    -4.56814f,    0.632069f,
    -9.79707f,    1.66636f,     0.287304f,    -9.21289f,    -1.87705f,
    -0.105345f,   -9.77792f,    1.10133f,     0.995988f,    -8.88728f,
    -1.47483f,    -0.335188f,   -9.44273f,    1.24498f,     0.497994f,
    -9.44273f,    -1.34075f,    -0.268151f,   -9.7875f,     1.0726f,
    0.68953f,     -9.39485f,    -1.27372f,    -0.162806f,   -8.86812f,
    2.24097f,     0.545878f,    -8.61913f,    -2.47082f,    0.632069f,
    -9.0022f,     2.02071f,     0.718261f,    -9.36612f,    -2.12605f,
    -0.440533f,   -9.22246f,    2.29843f,     1.05345f,     -9.10754f,
    -2.46124f,    -0.402226f,   -9.55765f,    2.32716f,     0.842759f,
    -9.19373f,    -2.50912f,    -0.497994f,   -8.95431f,    2.62405f,
    1.0726f,      -9.15543f,    -2.73897f,    -0.737414f,   -9.54808f,
    2.34632f,     1.11091f,     -9.05966f,    -2.55701f,    -0.440533f,
    -10.0556f,    -0.746991f,   1.15879f,     -8.90643f,    1.48441f,
    -1.74298f,    -8.53294f,    -2.1452f,     2.67193f,     -9.15543f,
    2.84431f,     -1.62806f,    -8.94474f,    1.81959f,     0.42138f,
    -9.30866f,    -1.75256f,    -0.746991f,   -9.92157f,    2.12605f,
    0.670376f,    -9.35654f,    -2.24097f,    -0.699107f,   -9.49062f,
    2.12605f,     1.25456f,     -8.91601f,    -2.36547f,    -0.411803f,
    -8.86812f,    2.40378f,     0.948104f,    -8.95431f,    -2.47082f,
    -0.871489f,   -8.90643f,    2.65278f,     1.49398f,     -8.95431f,
    -2.88262f,    -1.18752f,    -8.95431f,    3.15077f,     1.25456f,
    -9.05966f,    -3.34231f,    -1.10133f,    -9.02135f,    2.9305f,
    1.25456f,     -9.03093f,    -3.26569f,    -1.0726f,     -9.32781f,
    2.87304f,     1.0726f,      -8.97347f,    -3.26569f,    -0.794875f,
    -9.1267f,     2.94966f,     1.10133f,     -9.06924f,    -3.20823f,
    -0.679953f,   -9.06924f,    3.01669f,     1.01514f,     -8.98304f,
    -3.21781f,    -0.507571f,   -9.165f,      3.18908f,     0.555455f,
    -9.03093f,    -3.49553f,    -0.354342f,   -9.04051f,    3.32315f,
    0.344765f,    -9.05966f,    -3.48596f,    -0.181959f,   -8.76278f,
    3.02627f,     0.708684f,    -8.90643f,    -3.23696f,    -0.248997f,
    -8.85855f,    2.79643f,     0.641646f,    -8.90643f,    -2.96881f,
    -0.306458f,   -8.92558f,    2.7677f,      0.833182f,    -8.91601f,
    -3.02627f,    -0.430956f,   -8.94474f,    2.86347f,     1.00556f,
    -8.86812f,    -3.16035f,    -0.565032f,   -8.98304f,    2.94966f,
    1.1971f,      -9.07881f,    -3.20823f,    -0.766145f,   -8.89685f,
    2.92093f,     1.12049f,     -8.89685f,    -3.09331f,    -0.842759f,
    -8.83939f,    2.97839f,     0.967257f,    -8.85855f,    -3.1795f,
    -0.919373f,   -8.93516f,    3.15077f,     1.42694f,     -8.90643f,
    -3.43807f,    -0.948104f,   -8.99262f,    3.20823f,     1.33118f,
    -8.92558f,    -3.43807f,    -1.0726f,     -8.86812f,    3.01669f,
    1.52271f,     -8.77236f,    -3.33273f,    -1.08218f,    -8.81066f,
    3.23696f,     1.50356f,     -8.82024f,    -3.4668f,     -1.13964f,
    -8.86812f,    3.41892f,     1.40779f,     -8.90643f,    -3.62961f,
    -1.06303f,    -8.82982f,    3.38061f,     1.55144f,     -8.79151f,
    -3.62003f,    -1.08218f,    -8.82024f,    3.12204f,     1.67594f,
    -8.82024f,    -3.41892f,    -1.15879f,    -8.73405f,    3.25611f,
    1.75256f,     -8.72447f,    -3.4285f,     -1.28329f,    -8.79151f,
    3.32315f,     1.96325f,     -8.78193f,    -3.5913f,     -1.55144f,
    -8.71489f,    3.27527f,     2.02071f,     -8.73405f,    -3.48596f,
    -1.67594f,    -8.82024f,    3.16035f,     2.02071f,     -8.7532f,
    -3.41892f,    -1.62806f,    -8.73405f,    3.40934f,     1.90578f,
    -8.74362f,    -3.62003f,    -1.38864f,    -8.74362f,    3.41892f,
    1.93451f,     -8.68616f,    -3.66792f,    -1.45567f,    -8.70532f,
    3.40934f,     1.99198f,     -8.68616f,    -3.62961f,    -1.78129f,
    -8.69574f,    3.56257f,     1.93451f,     -8.72447f,    -3.77326f,
    -1.45567f,    -8.79151f,    3.45723f,     2.13563f,     -8.74362f,
    -3.68707f,    -1.54187f,    -8.79151f,    3.25611f,     2.03986f,
    -8.65743f,    -3.62003f,    -1.6089f,     -8.80109f,    3.32315f,
    1.92494f,     -8.69574f,    -3.5913f,     -1.88663f,    -8.99262f,
    3.13162f,     1.91536f,     -8.63828f,    -3.50511f,    -1.42694f,
    -8.69574f,    3.19865f,     2.22182f,     -8.86812f,    -3.43807f,
    -1.80044f,    -8.89685f,    2.61447f,     2.05901f,     -8.7532f,
    -2.85389f,    -1.39821f,    -9.32781f,    2.38462f,     2.08774f,
    -8.85855f,    -2.67193f,    -1.5706f,     -9.72046f,    1.13006f,
    1.86748f,     -9.03093f,    -0.756568f,   -1.0343f,     -10.3334f,
    0.42138f,     -1.53229f,    -9.57681f,    -0.220267f,   1.26414f,
    -8.95431f,    -0.383072f,   0.201113f,    -9.73961f,    0.651223f,
    -0.565032f,   -10.3334f,    -0.651223f,   -0.0574608f,  -9.68215f,
    0.536301f,    1.02472f,     -9.56723f,    -0.823605f,   -0.296881f,
    -9.58638f,    0.890643f,    0.0287304f,   -9.50977f,    -0.957681f,
    -0.0957681f,  -9.54808f,    0.890643f,    0.0861913f,   -9.72046f,
    -1.04387f,    -0.248997f,   -9.35654f,    1.00556f,     0.335188f,
    -9.47146f,    -0.948104f,   -0.325611f,   -9.45231f,    0.90022f,
    0.0383072f,   -9.70131f,    -0.814029f,   -0.191536f,   -9.51935f,
    0.756568f,    0.335188f,    -9.69173f,    -0.861913f,   -0.0383072f,
    -9.58638f,    0.775721f,    0.306458f,    -9.73004f,    -0.986411f,
    0.00957681f,  -9.47146f,    0.833182f,    0.258574f,    -9.64384f,
    -0.766145f,   -0.287304f,   -9.5385f,     0.699107f,    0.335188f,
    -9.60554f,    -0.842759f,   -0.153229f,   -9.5385f,     0.785298f,
    0.402226f,    -9.73961f,    -0.890643f,   -0.191536f,   -9.43316f,
    0.785298f,    0.411803f,    -9.663f,      -0.737414f,   -0.392649f,
    -9.56723f,    0.775721f,    0.335188f,    -9.60554f,    -0.766145f,
    -0.287304f,   -9.49062f,    0.679953f,    0.344765f,    -9.67257f,
    -0.785298f,   -0.201113f,   -9.44273f,    0.699107f,    0.316035f,
    -9.62469f,    -0.737414f,   -0.220267f,   -9.54808f,    0.679953f,
    0.440533f,    -9.96946f,    -0.497994f,   -0.392649f,   -9.61511f,
    0.440533f,    0.363919f,    -9.46189f,    -0.383072f,   -0.383072f,
    -9.48104f,    0.306458f,    0.565032f,    -9.69173f,    -1.0726f,
    -0.766145f,   -9.05008f,    0.909797f,    0.775721f,    -9.63427f,
    -0.430956f,   -0.737414f,   -9.54808f,    0.344765f,    0.718261f,
    -9.58638f,    -0.383072f,   -0.229843f,   -9.5385f,     0.172383f,
    0.632069f,    -9.62469f,    -0.335188f,   -0.545878f,   -9.52892f,
    0.306458f,    0.622492f,    -9.48104f,    -0.383072f,   -0.392649f,
    -9.44273f,    0.23942f,     0.68953f,     -9.70131f,    -0.344765f,
    -0.354342f,   -9.59596f,    0.229843f,    0.565032f,    -9.40442f,
    -0.392649f,   -0.497994f,   -9.43316f,    0.248997f,    0.555455f,
    -9.34696f,    -0.373495f,   -0.220267f,   -9.34696f,    0.181959f,
    0.392649f,    -10.4579f,    0.0670376f,   0.181959f,    -9.5385f,
    -0.229843f,   0.296881f,    -9.29908f,    -0.0287304f,  -0.42138f,
    -9.45231f,    0.00957681f,  0.565032f,    -9.84496f,    -0.0766145f,
    0.105345f,    -9.64384f,    -0.0574608f,  0.277727f,    -9.67257f,
    -0.21069f,    -0.306458f,   -9.29908f,    0.047884f,    0.469264f,
    -9.64384f,    -0.248997f,   0.114922f,    -9.52892f,    0.0191536f,
    0.201113f,    -9.64384f,    -0.411803f,   -0.0861913f,  -9.67257f,
    0.248997f,    0.0670376f,   -9.73004f,    -0.383072f,   -0.00957681f,
    -9.59596f,    0.268151f,    -0.047884f,   -9.77792f,    -0.162806f,
    0.0766145f,   -9.68215f,    0.00957681f,  0.153229f,    -9.68215f,
    -0.0957681f,  0.143652f,    -9.50977f,    -0.0957681f,  0.23942f,
    -9.60554f,    -0.316035f,   0.0f,         -9.43316f,    0.124498f,
    0.134075f,    -9.52892f,    -0.47884f,    -0.134075f,   -9.50019f,
    0.316035f,    -0.00957681f, -9.88326f,    -0.23942f,    -0.0670376f,
    -9.5385f,     0.0861913f,   0.316035f,    -9.60554f,    -0.0766145f,
    0.220267f,    -9.62469f,    -0.00957681f, -0.172383f,   -9.74919f,
    -0.00957681f, 0.0766145f,   -9.43316f,    -0.105345f,   0.0957681f,
    -9.69173f,    -0.0670376f,  0.00957681f,  -9.51935f,    -0.0383072f,
    -0.0383072f,  -9.71088f,    0.0191536f,   0.0766145f,   -9.50977f,
    -0.0957681f,  0.0766145f,   -9.56723f,    -0.105345f,   0.0861913f,
    -9.2895f,     -0.114922f,   0.153229f,    -9.71088f,    -0.162806f,
    0.0861913f,   -9.50019f,    0.0287304f,   0.0861913f,   -9.64384f,
    -0.0191536f,  0.287304f,    -9.50977f,    -0.134075f,   -0.0383072f,
    -9.50019f,    0.143652f,    0.21069f,     -9.44273f,    -0.23942f,
    -0.344765f,   -9.64384f,    -0.0287304f,  0.172383f,    -9.48104f,
    -0.0574608f,  -0.0957681f,  -9.69173f,    -0.181959f,   0.201113f,
    -9.48104f,    0.114922f,    -0.0574608f,  -9.75877f,    -0.0670376f,
    0.0191536f,   -9.55765f,    0.0383072f,   0.172383f,    -9.61511f,
    -0.0574608f,  0.268151f,    -9.24162f,    -0.0957681f,  -0.0574608f,
    -9.56723f,    0.047884f,    0.325611f,    -9.51935f,    -0.134075f,
    -0.459687f,   -9.47146f,    0.0f,         0.622492f,    -9.49062f,
    -0.0670376f,  -0.488417f,   -9.59596f,    0.0f,         0.823605f,
    -9.48104f,    -0.0383072f,  -0.574608f,   -9.5385f,     -0.335188f,
    0.641646f,    -9.54808f,    0.296881f,    -0.536301f,   -9.48104f,
    -0.363919f,   0.641646f,    -9.50977f,    0.287304f,    -0.45011f,
    -9.46189f,    -0.047884f,   1.13964f,     -9.57681f,    0.0f,
    -0.632069f,   -9.57681f,    -0.316035f,   0.909797f,    -9.63427f,
    0.258574f,    -0.517148f,   -9.64384f,    -0.344765f,   0.545878f,
    -9.59596f,    0.296881f,    -0.440533f,   -9.54808f,    -0.0574608f,
    0.746991f,    -9.59596f,    -0.0383072f,  -0.296881f,   -9.49062f,
    0.00957681f,  0.852336f,    -9.46189f,    -0.124498f,   -0.21069f,
    -9.57681f,    0.0766145f,   0.641646f,    -9.37569f,    -0.181959f,
    -0.42138f,    -9.70131f,    0.344765f,    0.737414f,    -9.24162f,
    -0.469264f,   -0.794875f,   -9.47146f,    0.0f,         0.699107f,
    -9.76834f,    0.0287304f,   -0.746991f,   -9.48104f,    -0.153229f,
    1.33118f,     -9.36612f,    0.0957681f,   -0.948104f,   -9.74919f,
    -0.201113f,   1.10133f,     -9.35654f,    0.181959f,    -0.909797f,
    -9.54808f,    0.0957681f,   0.881066f,    -9.73961f,    0.153229f,
    -1.05345f,    -9.49062f,    -0.306458f,   1.04387f,     -9.51935f,
    0.584185f,    -0.766145f,   -9.93115f,    -0.814029f,   0.727837f,
    -9.75877f,    1.0726f,      -0.316035f,   -9.72046f,    -0.296881f,
    0.162806f,    -9.47146f,    0.392649f,    0.0766145f,   -9.40442f,
    0.21069f,     0.287304f,    -9.37569f,    -0.248997f,   0.536301f,
    -9.5385f,     0.0861913f,   0.114922f,    -9.40442f,    -0.0287304f,
    -0.0383072f,  -10.0461f,    0.181959f,    -0.00957681f, -9.32781f,
    -0.181959f,   0.622492f,    -9.46189f,    0.296881f,    -0.201113f,
    -9.35654f,    -0.201113f,   0.201113f,    -9.31823f,    -0.402226f,
    0.21069f,     -9.91199f,    0.517148f,    1.01514f,     -9.87369f,
    0.047884f,    -0.047884f,   -9.56723f,    0.248997f,    -0.114922f,
    -9.76834f,    -0.335188f,   0.0383072f,   -9.02135f,    0.316035f,
    0.105345f,    -9.5385f,     -0.335188f,   0.0287304f,   -9.59596f,
    0.344765f,    0.670376f,    -9.70131f,    0.0287304f,   -0.383072f,
    -10.4579f,    0.402226f,    0.411803f,    -10.4291f,    -0.45011f,
    0.306458f,    -9.44273f,    0.545878f,    0.430956f,    -9.79707f,
    0.507571f,    -0.679953f,   -9.26077f,    -0.469264f,   1.26414f,
    -9.51935f,    0.775721f,    -0.114922f,   -9.19373f,    -0.718261f,
    0.718261f,    -9.68215f,    0.881066f,    -0.316035f,   -9.01178f,
    -0.890643f,   0.938527f,    -9.25119f,    1.04387f,     -0.861913f,
    -8.76278f,    -0.881066f,   -0.823605f,   -9.71088f,    0.354342f,
    -0.181959f,   -9.32781f,    -0.248997f,   -0.0957681f,  -10.4387f,
    0.995988f,    -0.268151f,   -10.2376f,    -0.699107f,   0.536301f,
    -9.98861f,    0.555455f,    -0.0574608f,  -9.49062f,    -0.459687f,
    0.823605f,    -9.79707f,    0.316035f,    0.268151f,    -8.85855f,
    -0.488417f,   -0.574608f,   -9.663f,      0.373495f,    -0.287304f,
    -9.42358f,    0.0191536f,   -1.65679f,    -9.42358f,    1.0726f,
    1.80044f,     -9.63427f,    -0.21069f,    -1.66636f,    -9.31823f,
    0.306458f,    2.83473f,     -9.17458f,    0.814029f,    -2.98796f,
    -8.67659f,    0.143652f,    1.7334f,      -9.31823f,    1.23541f,
    -1.15879f,    -9.13627f,    -1.75256f,    0.785298f,    -8.80109f,
    2.54743f,     -0.0766145f,  -9.91199f,    -0.134075f,   1.21625f,
    -9.72046f,    0.488417f,    0.363919f,    -9.14585f,    -0.277727f,
    1.0343f,      -9.21289f,    0.718261f,    -0.143652f,   -9.48104f,
    -0.296881f,   -0.114922f,   -9.2895f,     0.565032f,    0.565032f,
    -10.2663f,    0.459687f,    -0.143652f,   -9.56723f,    -0.105345f,
    0.459687f,    -10.094f,     0.68953f,     -0.306458f,   -9.59596f,
    -0.172383f,   0.957681f,    -10.094f,     0.0861913f,   -0.220267f,
    -9.34696f,    0.191536f,    0.392649f,    -9.79707f,    -0.181959f,
    -0.488417f,   -9.55765f,    0.555455f,    1.0343f,      -10.1227f,
    0.0191536f,   -0.976834f,   -9.40442f,    0.354342f,    0.871489f,
    -9.69173f,    0.593762f,    -0.296881f,   -9.14585f,    -0.517148f,
    1.31202f,     -9.69173f,    0.861913f,    -0.775721f,   -9.07881f,
    -0.68953f,    0.497994f,    -9.90242f,    0.919373f,    0.00957681f,
    -9.43316f,    -0.68953f,    0.325611f,    -9.79707f,    0.507571f,
    0.114922f,    -9.40442f,    -0.316035f,   0.430956f,    -9.8258f,
    0.536301f,    -0.0191536f,  -9.32781f,    -0.258574f,   0.258574f,
    -9.93115f,    0.383072f,    0.143652f,    -9.48104f,    -0.181959f,
    0.6608f,      -9.55765f,    0.0861913f,   -0.0383072f,  -9.37569f,
    0.0287304f,   0.430956f,    -9.39485f,    0.325611f,    0.0287304f,
    -9.32781f,    -0.0861913f,  0.392649f,    -9.50019f,    0.651223f,
    0.23942f,     -9.40442f,    -0.469264f,   0.545878f,    -9.75877f,
    0.536301f,    0.0574608f,   -9.38527f,    -0.411803f,   0.47884f,
    -9.87369f,    0.574608f,    0.0383072f,   -9.54808f,    -0.402226f,
    0.258574f,    -9.65342f,    0.325611f,    0.23942f,     -9.56723f,
    -0.220267f,   0.6608f,      -9.50977f,    0.134075f,    0.0766145f,
    -9.38527f,    -0.047884f,   0.536301f,    -9.70131f,    0.0f,
    -0.42138f,    -9.35654f,    0.181959f,    0.881066f,    -9.71088f,
    0.181959f,    -0.402226f,   -9.50019f,    -0.00957681f, 0.727837f,
    -9.49062f,    0.306458f,    -0.0766145f,  -9.27993f,    -0.268151f,
    0.766145f,    -9.73961f,    0.181959f,    -0.517148f,   -9.49062f,
    -0.0287304f,  0.986411f,    -9.86411f,    0.0383072f,   -0.383072f,
    -9.47146f,    0.0383072f,   0.986411f,    -9.50977f,    0.402226f,
    -0.383072f,   -9.10754f,    -0.363919f,   0.823605f,    -10.0365f,
    0.90022f,     -0.497994f,   -9.59596f,    -0.651223f,   0.833182f,
    -9.73961f,    0.517148f,    -0.0957681f,  -9.31823f,    -0.440533f,
    0.641646f,    -9.56723f,    0.0191536f,   -0.114922f,   -9.33739f,
    -0.047884f,   0.593762f,    -9.67257f,    -0.23942f,    -0.459687f,
    -9.51935f,    0.258574f,    0.794875f,    -9.39485f,    0.0574608f,
    -0.172383f,   -9.29908f,    -0.0574608f,  0.440533f,    -10.0078f,
    0.134075f,    -0.536301f,   -9.45231f,    -0.0670376f,  0.766145f,
    -10.0748f,    -0.0287304f,  -0.584185f,   -9.55765f,    -0.0766145f,
    1.06303f,     -9.73961f,    0.392649f,    -0.402226f,   -9.50019f,
    -0.316035f,   1.35991f,     -9.75877f,    0.229843f,    -0.373495f,
    -9.51935f,    -0.248997f,   1.39821f,     -10.2855f,    0.191536f,
    -0.181959f,   -10.1514f,    -0.124498f,   1.23541f,     -10.0461f,
    0.105345f,    -0.440533f,   -9.88326f,    0.0574608f,   -0.0191536f,
    -9.60554f,    -0.201113f,   0.0957681f,   -9.33739f,    0.047884f,
    -0.248997f,   -9.29908f,    -0.23942f,    0.373495f,    -9.04051f,
    -0.0861913f,  -0.00957681f, -9.24162f,    -0.114922f,   1.78129f,
    -9.414f,      -0.124498f,   -1.16837f,    -9.68215f,    -0.181959f,
    1.35033f,     -9.60554f,    0.0191536f,   -1.4461f,     -9.19373f,
    -0.220267f,   1.84832f,     -9.23204f,    -0.00957681f, -1.70467f,
    -9.11712f,    -0.181959f,   1.50356f,     -8.74362f,    -0.143652f,
    -1.97282f,    -8.89685f,    0.143652f,    1.88663f,     -8.90643f,
    -0.373495f,   -1.25456f,    -8.81066f,    -0.124498f,   1.31202f,
    -8.79151f,    -0.134075f,   -0.92895f,    -8.99262f,    -0.536301f,
    0.430956f,    -9.31823f,    0.373495f,    -0.181959f,   -10.2855f,
    -0.153229f,   0.708684f,    -10.5536f,    0.229843f,    -0.105345f,
    -10.2855f,    -0.220267f,   -0.105345f,   -9.95988f,    0.296881f,
    -0.162806f,   -9.79707f,    -0.0861913f,  0.536301f,    -9.39485f,
    -0.124498f,   -0.392649f,   -10.2759f,    0.047884f,    1.09176f,
    -9.61511f,    -0.191536f,   -0.517148f,   -10.0461f,    0.229843f,
    1.5706f,      -9.56723f,    -0.430956f,   -0.584185f,   -9.5385f,
    0.287304f,    0.938527f,    -9.49062f,    -0.47884f,    -0.287304f,
    -9.56723f,    -0.248997f,   0.497994f,    -9.50977f,    0.0766145f,
    -0.957681f,   -9.79707f,    -0.191536f,   0.296881f,    -9.40442f,
    0.00957681f,  -0.0383072f,  -9.61511f,    0.0191536f,   0.268151f,
    -9.31823f,    -0.201113f,   -0.344765f,   -9.48104f,    0.45011f,
    0.555455f,    -9.29908f,    -0.746991f,   0.0191536f,   -9.03093f,
    0.248997f,    0.612916f,    -8.97347f,    -0.459687f,   0.459687f,
    -9.11712f,    -0.277727f,   -0.402226f,   -9.0022f,     0.191536f,
    0.191536f,    -10.6207f,    -0.0766145f,  0.641646f,    -10.1897f,
    -0.00957681f, 0.344765f,    -10.0844f,    0.0574608f,   0.201113f,
    -10.1131f,    -0.124498f,   0.191536f,    -9.38527f,    -0.153229f,
    -0.0191536f,  -9.43316f,    -0.0574608f,  -0.134075f,   -9.42358f,
    -0.47884f,    0.172383f,    -9.27035f,    0.143652f,    0.21069f,
    -10.343f,     -0.0383072f,  -0.373495f,   -9.8258f,     0.0861913f,
    0.316035f,    -10.1706f,    -0.181959f,   -0.143652f,   -9.74919f,
    0.114922f,    0.258574f,    -9.50977f,    -0.430956f,   0.0670376f,
    -9.29908f,    0.172383f,    0.344765f,    -9.86411f,    -0.68953f,
    0.0191536f,   -10.0748f,    0.737414f,    0.440533f,    -9.91199f,
    -0.622492f,   -0.430956f,   -9.86411f,    0.708684f,    0.335188f,
    -9.88326f,    -0.392649f,   0.153229f,    -9.77792f,    0.354342f,
    -0.191536f,   -9.60554f,    0.0670376f,   0.0670376f,   -9.31823f,
    -0.277727f,   -0.0957681f,  -9.55765f,    0.593762f,    0.153229f,
    -9.23204f,    -0.852336f,   -0.201113f,   -9.63427f,    0.42138f,
    0.507571f,    -9.42358f,    -0.603339f,   -0.641646f,   -9.64384f,
    0.42138f,     0.718261f,    -9.47146f,    -0.507571f,   -0.995988f,
    -9.83538f,    0.134075f,    0.603339f,    -9.32781f,    -0.172383f,
    -0.861913f,   -9.60554f,    0.181959f,    1.05345f,     -9.72046f,
    -0.0574608f,  -1.21625f,    -9.57681f,    -0.00957681f, 1.1971f,
    -9.69173f,    0.363919f,    -1.31202f,    -9.29908f,    -0.306458f,
    1.37906f,     -9.33739f,    0.766145f,    -1.41737f,    -9.05008f,
    -0.0574608f,  1.09176f,     -9.07881f,    0.727837f,    -0.861913f,
    -9.42358f,    -0.785298f,   0.632069f,    -9.48104f,    1.01514f,
    0.047884f,    -9.69173f,    -1.04387f,    -0.124498f,   -8.99262f,
    1.11091f,     0.325611f,    -9.70131f,    -0.363919f,   -0.325611f,
    -9.50019f,    0.737414f,    1.31202f,     -9.76834f,    -0.162806f,
    -1.10133f,    -9.68215f,    0.296881f,    1.04387f,     -9.77792f,
    0.603339f,    -0.0957681f,  -9.83538f,    -0.47884f,    0.909797f,
    -10.4387f,    0.0766145f,   -0.459687f,   -9.9503f,     0.047884f,
    1.38864f,     -9.60554f,    -0.584185f,   0.459687f,    -9.75877f,
    0.536301f,    -0.124498f,   -9.74919f,    -0.172383f,   0.651223f,
    -10.4483f,    0.229843f,    -0.268151f,   -9.50019f,    -1.58975f,
    0.622492f,    -9.64384f,    1.58975f,     -0.114922f,   -8.96389f,
    -1.69509f,    1.16837f,     -8.72447f,    1.71425f,     -1.04387f,
    -8.91601f,    -0.90022f,    1.92494f,     -8.84897f,    1.04387f,
    -0.833182f,   -8.86812f,    -0.0574608f,  1.17795f,     -8.91601f,
    0.47884f,     -1.47483f,    -9.22246f,    1.25456f,     1.76213f,
    -8.88728f,    -1.42694f,    -2.36547f,    -10.1227f,    2.24097f,
    2.09732f,     -9.09797f,    -2.35589f,    -3.11246f,    -9.84496f,
    2.75812f,     2.1069f,      -9.26077f,    -2.98796f,    -2.33674f,
    -9.01178f,    0.0766145f,   4.2138f,      -8.45632f,    1.02472f,
    -3.69665f,    -8.51378f,    -0.344765f,   3.95522f,     -8.90643f,
    2.00155f,     -3.78284f,    -9.05966f,    -0.497994f,   3.50511f,
    -9.42358f,    1.86748f,     -3.62003f,    -9.68215f,    -0.488417f,
    3.74453f,     -9.48104f,    1.69509f,     -3.18908f,    -9.93115f,
    -0.871489f,   3.54342f,     -9.68215f,    2.03986f,     -2.8922f,
    -9.85453f,    -0.861913f,   3.16035f,     -9.81623f,    2.08774f,
    -2.66235f,    -9.95988f,    -0.852336f,   2.74854f,     -9.59596f,
    1.83875f,     -2.15478f,    -10.0652f,    -0.622492f,   2.28886f,
    -9.5385f,     1.46525f,     -2.18351f,    -9.67257f,    -0.632069f,
    2.01113f,     -9.43316f,    1.3216f,      -1.67594f,    -9.42358f,
    -0.679953f,   1.05345f,     -9.45231f,    1.5706f,      -1.23541f,
    -9.2895f,     -0.459687f,   1.39821f,     -9.5385f,     1.46525f,
    -1.16837f,    -9.58638f,    -0.316035f,   1.47483f,     -9.54808f,
    1.20668f,     -1.26414f,    -9.60554f,    -0.411803f,   1.39821f,
    -9.31823f,    1.14922f,     -1.14922f,    -9.76834f,    -0.354342f,
    1.35991f,     -9.52892f,    1.11091f,     -1.35991f,    -9.81623f,
    0.0574608f,   1.46525f,     -9.663f,      0.833182f,    -1.1971f,
    -9.80665f,    0.21069f,     1.62806f,     -9.70131f,    0.641646f,
    -1.24498f,    -9.9503f,     0.497994f,    1.53229f,     -9.88326f,
    0.325611f,    -1.05345f,    -9.86411f,    0.565032f,    1.58017f,
    -9.87369f,    0.220267f,    -1.24498f,    -9.94073f,    0.268151f,
    1.97282f,     -9.91199f,    0.584185f,    -1.35033f,    -9.25119f,
    0.306458f,    1.13006f,     -9.46189f,    0.383072f,    -1.11091f,
    -8.97347f,    -0.0670376f,  1.22583f,     -8.98304f,    0.459687f,
    -0.488417f,   -9.30866f,    -0.737414f,   1.23541f,     -9.13627f,
    1.00556f,     -0.526724f,   -10.6781f,    -0.775721f,   0.373495f,
    -10.5919f,    1.13964f,     0.42138f,     -9.54808f,    -2.07817f,
    0.68953f,     -9.26077f,    1.82917f,     -0.105345f,   -9.03093f,
    -0.976834f,   0.430956f,    -9.47146f,    0.995988f,    -0.181959f,
    -9.86411f,    -0.23942f,    0.124498f,    -9.73004f,    0.153229f,
    0.871489f,    -9.97903f,    -0.220267f,   0.162806f,    -9.59596f,
    0.153229f,    0.430956f,    -9.8258f,     -0.114922f,   0.0957681f,
    -9.76834f,    0.00957681f,  -0.0287304f,  -10.1801f,    -0.268151f,
    0.258574f,    -10.0844f,    0.23942f,     0.0766145f,   -10.1131f,
    0.794875f,    0.0f,         -9.86411f,    -0.593762f,   0.909797f,
    -9.29908f,    -2.09732f,    1.72383f,     -9.17458f,    1.89621f,
    -1.58975f,    -8.91601f,    -2.16436f,    1.94409f,     -9.1267f,
    2.03986f,     -1.96325f,    -9.30866f,    -2.42293f,    2.02071f,
    -9.43316f,    2.26013f,     -1.38864f,    -9.8258f,     -2.2697f,
    1.16837f,     -9.44273f,    2.16436f,     -1.09176f,    -9.14585f,
    -2.03986f,    1.26414f,     -9.01178f,    1.82917f,     -1.28329f,
    -8.89685f,    -2.09732f,    1.64721f,     -8.95431f,    1.93451f,
    -1.69509f,    -8.8777f,     -2.19309f,    1.28329f,     -9.03093f,
    2.11647f,     -1.40779f,    -9.31823f,    -2.2697f,     1.09176f,
    -9.11712f,    2.06859f,     -1.3216f,     -9.2895f,     -2.21224f,
    1.4461f,      -9.165f,      2.00155f,     -1.48441f,    -8.98304f,
    -2.20267f,    1.46525f,     -8.83939f,    2.00155f,     -1.24498f,
    -9.14585f,    -2.26013f,    1.43652f,     -9.01178f,    2.1069f,
    -1.45567f,    -9.1267f,     -2.29843f,    1.63763f,     -9.04051f,
    2.12605f,     -1.76213f,    -9.18416f,    -2.27928f,    1.9824f,
    -9.09797f,    2.07817f,     -1.79086f,    -9.08839f,    -2.00155f,
    1.79086f,     -9.44273f,    1.87705f,     -1.62806f,    -9.14585f,
    -2.31759f,    1.84832f,     -8.86812f,    2.06859f,     -1.61848f,
    -9.165f,      -2.24097f,    2.05901f,     -9.0022f,     2.02071f,
    -1.7334f,     -9.04051f,    -2.1452f,     2.04944f,     -9.2895f,
    2.06859f,     -1.70467f,    -9.20331f,    -2.22182f,    2.06859f,
    -9.33739f,    2.09732f,     -1.76213f,    -9.34696f,    -2.13563f,
    1.99198f,     -9.1267f,     1.9824f,      -1.84832f,    -8.88728f,
    -1.79086f,    1.55144f,     -9.03093f,    1.62806f,     -1.61848f,
    -9.1267f,     -1.58975f,    1.47483f,     -9.19373f,    1.49398f,
    -1.47483f,    -8.92558f,    -1.48441f,    1.76213f,     -8.69574f,
    1.18752f,     -1.76213f,    -9.24162f,    -1.35991f,    1.49398f,
    -9.48104f,    1.23541f,     -1.61848f,    -9.51935f,    1.86748f,
    2.00155f,     -8.71489f,    -1.24498f,    -2.11647f,    -5.6982f,
    8.15944f,     1.27372f,     -4.52983f,    -7.99663f,    -0.775721f,
    -4.00311f,    8.31267f,     0.632069f,    -3.68707f,    -8.03494f,
    0.344765f,    -2.16436f,    7.79552f,     3.7158f,      -1.7334f,
    -7.74764f,    -4.22337f,    -1.56102f,    8.78193f,     4.39575f,
    -1.58017f,    -8.76278f,    -4.5011f,     -1.72383f,    9.05008f,
    5.25767f,     -1.93451f,    -9.11712f,    -3.9648f,     -0.995988f,
    7.97748f,     5.34386f,     -1.33118f,    -7.92002f,    -4.03184f,
    -0.670376f,   9.17458f,     4.3766f,      0.220267f,    -9.60554f,
    -4.13718f,    -0.746991f,   7.33583f,     5.34386f,     -1.1971f,
    -7.28795f,    -5.14275f,    0.871489f,    7.90087f,     5.80354f,
    0.584185f,    -8.33182f,    -3.04542f,    0.986411f,    7.59441f,
    6.49307f,     -0.0670376f,  -7.85298f,    -5.92804f,    2.07817f,
    8.83939f,     5.4109f,      0.325611f,    -9.59596f,    -3.83072f,
    0.718261f,    7.38372f,     5.99508f,     0.248997f,    -8.29351f,
    -5.10444f,    1.72383f,     7.83383f,     5.85143f,     2.12605f,
    -9.15543f,    -4.03184f,    2.05901f,     7.37414f,     5.79397f,
    2.19309f,     -8.49463f,    -4.95121f,    2.13563f,     7.91044f,
    4.29999f,     2.1452f,      -8.76278f,    -2.24097f,    1.31202f,
    8.59997f,     5.72693f,     0.746991f,    -9.55765f,    -3.54342f,
    1.36948f,     8.5042f,      5.09486f,     1.17795f,     -9.62469f,
    -4.1276f,     1.77171f,     8.69574f,     5.46836f,     1.63763f,
    -9.40442f,    -2.32716f,    1.91536f,     7.75721f,     5.25767f,
    2.04944f,     -8.81066f,    -2.40378f,    0.392649f,    7.73806f,
    5.63116f,     1.45567f,     -9.24162f,    -1.49398f,    -0.258574f,
    6.82826f,     7.34541f,     -0.42138f,    -9.07881f,    -1.30245f,
    -0.517148f,   6.97192f,     7.6806f,      -0.890643f,   -9.58638f,
    -4.81713f,    -0.21069f,    3.13162f,     9.20331f,     -0.967257f,
    -10.0748f,    0.181959f,    -0.948104f,   -5.9855f,     7.4316f,
    -1.00556f,    -9.5385f,     0.497994f,    0.162806f,    -8.47547f,
    4.32872f,     0.248997f,    -9.165f,      -2.27928f,    0.143652f,
    -8.6287f,     4.47237f,     0.354342f,    -9.51935f,    0.986411f,
};

extern const size_t kAccelerometerVerticalHingeTestDataLength =
    base::size(kAccelerometerVerticalHingeTestData);

extern const float kAccelerometerVerticalHingeUnstableAnglesTestData[] = {
    8.5904f,   -1.36948f,  -3.74453f,   8.72447f,  1.1971f,    4.00311f,
    8.80109f,  -3.08373f,  2.27928f,    8.95431f,  -1.90578f,  -1.10133f,
    8.93516f,  -2.03986f,  0.248997f,   9.05008f,  1.53229f,   -0.708684f,
    -8.78193f, 1.43652f,   -2.63362f,   -8.66701f, 0.220267f,  2.79643f,
    -8.66701f, -2.06859f,  2.42293f,    -8.79151f, -2.88262f,  -1.16837f,
    8.74362f,  -1.9824f,   3.53384f,    9.04051f,  0.0574608f, -1.36948f,
    8.78193f,  -4.1276f,   2.58574f,    8.8777f,   0.201113f,  -1.80044f,
    8.70532f,  -0.296881f, 1.52271f,    9.02135f,  -0.871489f, -2.43251f,
    -9.09797f, -1.3216f,   -3.60088f,   -8.97347f, 2.52828f,   2.6432f,
    -8.82024f, 1.87705f,   0.354342f,   -7.93917f, -4.38618f,  0.258574f,
    -8.81066f, 1.91536f,   -2.92093f,   -8.04452f, -5.4492f,   3.28484f,
    -8.86812f, 2.05901f,   0.890643f,   -8.01579f, -5.65989f,  -2.20267f,
    -9.0022f,  2.18351f,   -2.9305f,    -8.80109f, -4.01268f,  3.055f,
    -9.37569f, -1.04387f,  0.277727f,   -6.80911f, 2.806f,     -6.0717f,
    -8.79151f, -8.79151f,  -2.11647f,   -8.6287f,  -1.53229f,  3.58173f,
    -8.97347f, -0.335188f, 1.26414f,    8.5042f,   1.51314f,   -2.20267f,
    -9.19373f, -1.37906f,  1.41737f,    -7.67102f, 2.8922f,    -5.09486f,
    -8.81066f, 0.986411f,  2.30801f,    -8.53294f, 3.26569f,   -3.11246f,
    -9.03093f, 1.06303f,   1.39821f,    -8.8777f,  -4.47237f,  -0.632069f,
    -8.74362f, -1.83875f,  -0.0957681f, -7.92002f, 1.0343f,    -3.84988f,
    -8.92558f, 0.440533f,  1.26414f,    -8.71489f, -0.153229f, -3.64876f,
};

extern const size_t kAccelerometerVerticalHingeUnstableAnglesTestDataLength =
    base::size(kAccelerometerVerticalHingeUnstableAnglesTestData);

}  // namespace ash
