/*
 * Copyright (c) 2016, Peter Abeles. All Rights Reserved.
 *
 * This file is part of DeepBoof
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package deepboof.io.torch7;

import deepboof.Function;
import deepboof.Tensor;

import java.util.ArrayList;
import java.util.List;

/**
 * Storage for a saved DeepBoof function and learned parameters
 *
 * @author Peter Abeles
 */
public class FunctionAndParameters<T extends Tensor<T>> {
	public Function<T> function;
	public List<T> parameters = new ArrayList<>();

	public <F extends Function<T>> F getFunction() {
		return (F)function;
	}
}
