%----------------------------------------------------------------------
% File:      xcolor.tst
% Purpose:   Tests for xcolor package.
% Author:    A.Kryukov
% E-address: kryukov@npi.msu.su
% Vertion:   2.2.1
% Release:   Aug. 17, 1994
%----------------------------------------------------------------------
% Revision:  14/03/91  Start
%            17/08/94  C0a,C0b,C0c,C0d
%----------------------------------------------------------------------

%load xcolor$
%in "xcolor.red"$

% on time$

SUdim n$        % Set the order of the SU(n) group, i.e. SU(n).
                % n=3 is a default value.

spTT 1/2$       % Set the normalization coefficient A:
		%     Sp(TiTj) = A*Delta(i,j)
                % A=1/2 is a default value.

                % QG(inQuark,outQuark,gluon) - quark-gluon vertex.
                % G3(gluon1,gluon2,gluon3)   - three-gluon vertex.

%----------------------------------------------------------------------
%               Run time (ms) without GC, compiled vertion.
%----------------------------------------------------------------------
% Test   | SUN3/60 |i386SX-25|DEC APX   |HP 735    |
%        |         |RAM=2M   |3000/128MB|          |
%        |         |         |R=20MB    |R=8MB     |
%----------------------------------------------------------------------
% c1     | 323     | 2800    |34        |40        |
% c2     | 102     | 170     |0         |0         |
% c3     | 102     | 160     |0         |10        |
%----------------------------------------------------------------------
% c4a    | 323     | 1270    |17        |20        |
% c4b    | 51      | 110     |-         |10        |
% c4c    | 135     | 160     |17        |0         |
%----------------------------------------------------------------------
% c0a    |         |         |17        |20        |
% c0b    |         |         |0         |0         |
% c0c    |         |         |17        |20        |
% c0d    |         |         |17        |0         |
%----------------------------------------------------------------------
% cz     | 187     | 990     |0         |10        |
% c0     | 374     | 330     |          |20        |
%----------------------------------------------------------------------
% c91    | 255     | 1480    |17        |10        |
% c92    | 323     | 1480    |17        |20        |
% c93    | 2397    | 2970    |68        |130       |
% c94    | 18411   | 35838   |495       |750       |
% c95    | 139009  | 262956  |3485      |5670      |
%----------------------------------------------------------------------

%----------------------------------------------------------------------
% Test 1. See test run in: A.Kryukov & A.Rodionov
%               Program "COLOR" for computing the group-theoretical
%               weight of Feynman diagrams in non-abelian theories.
%               Comp. Phys. Comm., 48(1988), 327-334.
%----------------------------------------------------------------------

%----------------------------------------------------------------------
%         1     4                  1  4                  1
% c1.   --*--<--*--     c2.   --<--*--*--     c3.   --<--*--<--
%      |  :     :  |         |     :  :  |         |     :     |
%      |  :     :  |         |     :  :  |         |     *4    |
%      |  :     :  |         |   ..:..   |         |    : :    |
%      |  :     :  |         |  :  :     |         |   :   :   |
%       --*-->--*--           --*--*-->--           ---*->-*---
%         2     3               2  3                   2   3
%----------------------------------------------------------------------
%
%         4      2
%        N  - 2*N  + 1
% C1 := ---------------
%             4*N
%
%
%            2
%         - N  + 1
% C2 := -----------
%           4*N
%
%
%            2
%        N*(N  - 1)
% C3 := ------------
%            4
%
%----------------------------------------------------------------------

c1 := QG(e4,e1,e5)*QG(e1,e2,e5)*QG(e2,e3,e6)*QG(e3,e4,e6);
c2 := QG(e4,e1,e5)*QG(e1,e2,e6)*QG(e2,e3,e5)*QG(e3,e4,e6);
c3 := QG(e3,e1,e4)*QG(e1,e2,e5)*QG(e2,e3,e6)*G3(e4,e6,e5);

%----------------------------------------------------------------------
%
% c4a. --*--<--*--      c4b. --*--<--*--      c4c. --*--<--*--
%     |  :     :  |         |  :     :  |         |  :     :  |
%     |   ..*..   |         |  :     :  |         |  *...  :  |
%     |     :     |         |  *.....*  |         |  :   : :  |
%     |   ..*..   |         |  :     :  |         |  *...:.   |
%     |  :     :  |         |  :     :  |         |  :   :    |
%      --*-->--*--           --*-->--*--           --*---*->--
%
%----------------------------------------------------------------------
%
%          2   2
%         N *(N  - 1)
% C4A := -------------
%              8
%
%
%          2   2
%         N *(N  - 1)
% C4B := -------------
%              8
%
%
% C4C := 0
%
%----------------------------------------------------------------------

c4a := QG(e4,e1,e7)*QG(e1,e2,e9)*QG(e2,e3,e8)*QG(e3,e4,e5)
      *G3(e5,e6,e7)*G3(e6,e8,e9);
c4b := c4a;
c4c := QG(e4,e1,e7)*QG(e1,e2,e9)*QG(e2,e3,e5)*QG(e3,e4,e8)
      *G3(e5,e6,e7)*G3(e6,e8,e9);

%----------------------------------------------------------------------
% Test 2.
%----------------------------------------------------------------------
%        ......1......
%       :             :
%       :    3   6    :
%      1*.3..*-6-*..4.*2
%       :    |   |    :  = N^2*(N^2-1)/8
% C0a:  2    V   |    5
%       :    |   |    :
%       :    7   9    :
%       :    |   |    :
%        ....*-8-*....
%            4   5
%
%        ......1......
%       :             :
%       :    3   6    :
%      1*.3..*-6-*..4.*2
%       :    |   |    :  = 0
% C0b:  2    V   |    5
%       :    |   |    :
%       :     \ /     :
%       :      X      :
%       :     / \
%       :    7   9    :
%       :    |   |    :
%        ....*-8-*....
%            4   5
%
%-------------------------------------------------------

C0a :=  g3(e1,e3,e2)*g3(e1,e5,e4)
       *qg(e6,e7,e3)*qg(e7,e8,e2)*qg(e8,e9,e5)*qg(e9,e6,e4);

C0b :=  g3(e1,e3,e2)*g3(e1,e5,e4)
       *qg(e6,e9,e3)*qg(e9,e8,e5)*qg(e8,e7,e2)*qg(e7,e6,e4);

%--------------------------------------------------------
%
%        ......1......
%       :             :
%       :    3        :
%      1*.3..*-6--   -*2
%       :    |    \ / |  = (N^2-1)/8
% C0c:  2    V     X  V
%       :    |    / \ 4
%       :    |   |   -*6
%       :    7   9    :
%       :    |   |    5
%        ....*-8-*....
%            4   5
%
%        ......1......
%       :             :
%       :    3        :
%      1*.3..*-6------*2
%       :    |        |  = -(N^2-1)^2/8
% C0d:  2    V        A
%       :    |        4
%       :    |   |----*6
%       :    7   9    :
%       :    |   |    5
%        ....*-8-*....
%            4   5
%
%----------------------------------------------------------------------

C0c := g3(e1,e3,e2)*qg(e9,e4,e1)*qg(e6,e7,e3)
      *qg(e7,e8,e2)*qg(e8,e9,e5)*qg(e4,e6,e5);

C0d := g3(e1,e3,e2)*qg(e4,e6,e1)*qg(e6,e7,e3)
      *qg(e7,e8,e2)*qg(e8,e9,e5)*qg(e9,e4,e5);

%----------------------------------------------------------------------
%            1                     1
% cz.   .....*.....     c0.   .....*.....
%      :     :     :         :     :e2   :
%      :     :     :         :e3   *4    :e1
%      :     :     :         :    : :    :
%      :     :     :         :   :e4 :e6 :
%       .....*.....           ...*...*...
%            2                   2e5 3
%----------------------------------------------------------------------
%
%           2
% CZ := N*(N  - 1)
%
%
%        2   2
%       N *(N  - 1)
% C0 := -----------
%            2
%
%----------------------------------------------------------------------

cz := G3(e1,e2,e3)*G3(e1,e3,e2);
c0 := G3(e1,e2,e3)*G3(e3,e4,e5)*G3(e5,e6,e1)*G3(e2,e6,e4);

%$END$
%----------------------------------------------------------------------
% Test 3.
%----------------------------------------------------------------------

%----------------------------------------------------------------------
%
%                 1
% c9n.   .....*.......*.....
%       :     :   2   :     :
%       :     *.......*     :
%       :     :       :     :
%       :     :  ...  :     :
%       :     :       :     :
%       :     :   n   :     :
%        .....*.......*.....
%
%----------------------------------------------------------------------
%
% C91 := 0
%
%
%         2   2
% C92 := N *(N  - 1)
%
%
%          3   2
%         N *(N  - 1)
% C93 := -------------
%              4
%
%
%          2   4       2
%         N *(N  + 11*N  - 12)
% C94 := ----------------------
%                  8
%
%
%          3   4       2
%         N *(N  + 15*N  - 16)
% C95 := ----------------------
%                  16
%
%----------------------------------------------------------------------

c91 := G3(e3,e1,e1)*G3(e3,e2,e2);
c92 := G3(e3,e4,e1)*G3(e3,e2,e5)*G3(e6,e1,e4)*G3(e6,e5,e2);
c93 := G3(e3,e4,e1)*G3(e3,e2,e5)*G3(e6,e7,e4)*G3(e6,e5,e8)
      *G3(e9,e1,e7)*G3(e9,e8,e2);
c94 := G3(e3,e4,e1)*G3(e3,e2,e5)*G3(e6,e7,e4)*G3(e6,e5,e8)
      *G3(e9,e10,e7)*G3(e9,e8,e11)*G3(e12,e1,e10)*G3(e12,e11,e2);
c95 := G3(e3,e4,e1)*G3(e3,e2,e5)*G3(e6,e7,e4)*G3(e6,e5,e8)
      *G3(e9,e10,e7)*G3(e9,e8,e11)*G3(e12,e13,e10)*G3(e12,e11,e14)
      *G3(e15,e1,e13)*G3(e15,e14,e2);

%----------------------------------------------------------------------
$END$ % xColor tests
%----------------------------------------------------------------------
