% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statement.R
\name{getTermType}
\alias{getTermType}
\alias{getTermType,Statement,character-method}
\title{Return the redland node type for the specified RDF term in a statement}
\usage{
getTermType(.Object, term)

\S4method{getTermType}{Statement,character}(.Object, term)
}
\arguments{
\item{.Object}{a Statement object}

\item{term}{the RDF term for which the type will be returned}
}
\description{
After a Statement object has been created, this method can
be used to determine the RDF type ("uri", "literal", "blank") that has been
assigned to the specified RDF term, i.e. "subject", "predicate", "object".
}
\examples{
world <- new("World")
subject <- new("Node", blank="_:myid1", world)
predicate <- new("Node", uri="http://www.example.com/isa", world)
object <- new("Node", literal="thing", world)
stmt <- new("Statement", world, subject, predicate, object, world)
termType <- getTermType(stmt, "predicate")
}
