const QUERY = [
    '<P>',
    '-> <P>',
    'a<"P">',
    '"P" "P"',
    'P "P"',
    '"p" p',
    '"const": p',
    "a<:a>",
    "a<::a>",
    "((a))",
    "(p -> p",
    "::a::b",
    "a::::b",
    "a::b::",
    ":a",
    "a b:",
    "a (b:",
    "_:",
    "_:a",
    "a-bb",
    "a>bb",
    "ab'",
    "a->",
    '"p" <a>',
    '"p" a<a>',
    "a,<",
    "aaaaa<>b",
    "fn:aaaaa<>b",
    "->a<>b",
    "a<->",
    "a:: a",
    "a ::a",
    "a<a>:",
    "a<>:",
    "a,:",
    "  a<>  :",
    "mod : :",
    "a!a",
    "a!!",
    "mod:a!",
    "a!::a",
    "a<",
];

const PARSED = [
    {
        elems: [],
        foundElems: 0,
        original: "<P>",
        returned: [],
        userQuery: "<p>",
        error: "Found generics without a path",
    },
    {
        elems: [],
        foundElems: 0,
        original: "-> <P>",
        returned: [],
        userQuery: "-> <p>",
        error: "Found generics without a path",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<\"P\">",
        returned: [],
        userQuery: "a<\"p\">",
        error: "Unexpected `\"` in generics",
    },
    {
        elems: [],
        foundElems: 0,
        original: "\"P\" \"P\"",
        returned: [],
        userQuery: "\"p\" \"p\"",
        error: "Cannot have more than one literal search element",
    },
    {
        elems: [],
        foundElems: 0,
        original: "P \"P\"",
        returned: [],
        userQuery: "p \"p\"",
        error: "Cannot use literal search when there is more than one element",
    },
    {
        elems: [],
        foundElems: 0,
        original: "\"p\" p",
        returned: [],
        userQuery: "\"p\" p",
        error: "You cannot have more than one element if you use quotes",
    },
    {
        elems: [],
        foundElems: 0,
        original: "\"const\": p",
        returned: [],
        userQuery: "\"const\": p",
        error: "You cannot use quotes on type filter",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<:a>",
        returned: [],
        userQuery: "a<:a>",
        error: "Expected type filter before `:`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<::a>",
        returned: [],
        userQuery: "a<::a>",
        error: "Unexpected `::`: paths cannot start with `::`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "((a))",
        returned: [],
        userQuery: "((a))",
        error: "Unexpected `(`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "(p -> p",
        returned: [],
        userQuery: "(p -> p",
        error: "Unexpected `(`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "::a::b",
        returned: [],
        userQuery: "::a::b",
        error: "Paths cannot start with `::`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a::::b",
        returned: [],
        userQuery: "a::::b",
        error: "Unexpected `::::`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a::b::",
        returned: [],
        userQuery: "a::b::",
        error: "Paths cannot end with `::`",
    },
    {
        elems: [],
        foundElems: 0,
        original: ":a",
        returned: [],
        userQuery: ":a",
        error: "Expected type filter before `:`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a b:",
        returned: [],
        userQuery: "a b:",
        error: "Unexpected `:` (expected path after type filter)",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a (b:",
        returned: [],
        userQuery: "a (b:",
        error: "Unexpected `(`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "_:",
        returned: [],
        userQuery: "_:",
        error: "Unexpected `:` (expected path after type filter)",
    },
    {
        elems: [],
        foundElems: 0,
        original: "_:a",
        returned: [],
        userQuery: "_:a",
        error: "Unknown type filter `_`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a-bb",
        returned: [],
        userQuery: "a-bb",
        error: "Unexpected `-` (did you mean `->`?)",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a>bb",
        returned: [],
        userQuery: "a>bb",
        error: "Unexpected `>` (did you mean `->`?)",
    },
    {
        elems: [],
        foundElems: 0,
        original: "ab'",
        returned: [],
        userQuery: "ab'",
        error: "Unexpected `'`",
    },
    {
        elems: [],
        foundElems: 0,
        original: "a->",
        returned: [],
        userQuery: "a->",
        error: "Expected at least one item after `->`",
    },
    {
        elems: [],
        foundElems: 0,
        original: '"p" <a>',
        returned: [],
        userQuery: '"p" <a>',
        error: "Found generics without a path",
    },
    {
        elems: [],
        foundElems: 0,
        original: '"p" a<a>',
        returned: [],
        userQuery: '"p" a<a>',
        error: "You cannot have more than one element if you use quotes",
    },
    {
        elems: [],
        foundElems: 0,
        original: 'a,<',
        returned: [],
        userQuery: 'a,<',
        error: 'Found generics without a path',
    },
    {
        elems: [],
        foundElems: 0,
        original: 'aaaaa<>b',
        returned: [],
        userQuery: 'aaaaa<>b',
        error: 'Expected `,`, ` `, `:` or `->`, found `b`',
    },
    {
        elems: [],
        foundElems: 0,
        original: 'fn:aaaaa<>b',
        returned: [],
        userQuery: 'fn:aaaaa<>b',
        error: 'Expected `,`, ` `, `:` or `->`, found `b`',
    },
    {
        elems: [],
        foundElems: 0,
        original: '->a<>b',
        returned: [],
        userQuery: '->a<>b',
        error: 'Expected `,` or ` `, found `b`',
    },
    {
        elems: [],
        foundElems: 0,
        original: 'a<->',
        returned: [],
        userQuery: 'a<->',
        error: 'Unexpected `-` after `<`',
    },
    {
        elems: [],
        foundElems: 0,
        original: 'a:: a',
        returned: [],
        userQuery: 'a:: a',
        error: 'Paths cannot end with `::`',
    },
    {
        elems: [],
        foundElems: 0,
        original: 'a ::a',
        returned: [],
        userQuery: 'a ::a',
        error: 'Paths cannot start with `::`',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<a>:",
        returned: [],
        userQuery: "a<a>:",
        error: 'Unexpected `<` in type filter',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<>:",
        returned: [],
        userQuery: "a<>:",
        error: 'Unexpected `<` in type filter',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a,:",
        returned: [],
        userQuery: "a,:",
        error: 'Unexpected `,` in type filter',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<>  :",
        returned: [],
        userQuery: "a<>  :",
        error: 'Unexpected `<` in type filter',
    },
    {
        elems: [],
        foundElems: 0,
        original: "mod : :",
        returned: [],
        userQuery: "mod : :",
        error: 'Unexpected `:`',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a!a",
        returned: [],
        userQuery: "a!a",
        error: 'Unexpected `!`: it can only be at the end of an ident',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a!!",
        returned: [],
        userQuery: "a!!",
        error: 'Cannot have more than one `!` in an ident',
    },
    {
        elems: [],
        foundElems: 0,
        original: "mod:a!",
        returned: [],
        userQuery: "mod:a!",
        error: 'Invalid search type: macro `!` and `mod` both specified',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a!::a",
        returned: [],
        userQuery: "a!::a",
        error: 'Cannot have associated items in macros',
    },
    {
        elems: [],
        foundElems: 0,
        original: "a<",
        returned: [],
        userQuery: "a<",
        error: "Unclosed `<`",
    },
];
