//
// Copyright (C) 2006-2013 SIPez LLC.  All rights reserved.
//
// Copyright (C) 2004-2006 SIPfoundry Inc.
// Licensed by SIPfoundry under the LGPL license.
//
// Copyright (C) 2004-2006 Pingtel Corp.  All rights reserved.
// Licensed to SIPfoundry under a Contributor Agreement.
//
// $$
///////////////////////////////////////////////////////////////////////////////


//  Border Guard
#ifndef _IGetByeInfo_h
#define _IGetByeInfo_h

#include "rtcp/RtcpConfig.h"

// Include
#include "IBaseClass.h"

/**
 *
 * Interface Name:  IGetByeInfo
 *
 * Inheritance:     None
 *
 *
 * Description:  The IGetByeInfo interface allows consumers to extract
 *               information from an RTCP Bye packet.  This data will allow
 *               a consumer to retrieve the reason for termination and the
 *               SSRC and CSRCS affected by the termination.
 *
 * Notes:
 *
 */
interface IGetByeInfo : public IBaseClass
 {

//  Public Methods

public:

/**
 *
 * Method Name:  GetSSRC
 *
 *
 * Inputs:       None
 *
 *
 * Outputs:      None
 *
 * Returns:     ssrc_t - The SSRC of the Bye Report
 *
 * Description: Returns the SSRC Associated with the Bye Report.
 *
 * Usage Notes:
 *
 *
 */
    virtual ssrc_t GetSSRC(void)=0;


/**
 *
 * Method Name:  GetReason
 *
 *
 * Inputs:      None
 *
 * Outputs: unsigned char *puchReason
 *           Character buffer in which the Reason attribute shall be returned
 *
 * Returns: unsigned long
 *           Length of the item being returned in the unsigned character buffer
 *
 * Description: Retrieves the Reason attribute stored within the object and
 *              returns its associated length.
 *
 * Usage Notes: All unsigned character strings returned are limited to 255
 *              bytes in length. Any wide unsigned character support for
 *              internationalized display is a responsibility assumed by
 *              the caller.
 */
    virtual unsigned long GetReason(unsigned char *puchReason)=0;

/**
 *
 * Method Name:  GetCSRC
 *
 *
 * Inputs:  bool bNBO
 *           Flag identifying whether data should be represented in NBO format

 *
 * Outputs: ssrc_t *paulCSRC
 *           Contributing Source Identifier(s) Array pointer
 *
 * Returns: unsigned long - Number of Contributing Source Identifier(s)
 *
 * Description: Returns the contributing source values associated with the
 *              RTP packet.
 *
 * Usage Notes:
 *
 *
 */
    virtual unsigned long GetCSRC(ssrc_t *paulCSRC, bool bNBO=FALSE)=0;

/**
 *
 * Method Name:  GetByeInterface()
 *
 *
 * Inputs:      None
 *
 * Outputs:     None
 *
 * Returns:     IByeReport *  - Pointer to the Bye Report Interface
 *
 * Description: Returns the Bye Report interface.
 *
 * Usage Notes:
 *
 */
    virtual IByeReport * GetByeInterface(void) = 0;

};

#endif

