/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * February 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef RAWPIXBUF_H
#define RAWPIXBUF_H
#include <vdk/vdkobj.h>
#include <vdk/rawobj.h>
class VDKObject;
class VDKForm;
/*!
  \class VDKPixbuf
  \brief Provides a raw image wrapping GdkPixbuf
  This class should in time substitute VDKRawPixmap that from now
  should be considered deprecated ven if will continue to be supported
  in earler versions of vdk 2.x series.
 */
class VDKPixbuf : public VDKRawObject
{
 protected:
  GdkPixbuf *pixbuf;
  int w,h;
 public:
  /*!
    Constructor
    \param owner
    \param pixfile (type of file will be autodetected)
   */
  VDKPixbuf(VDKObject* owner, const char* pixfile);
  /*!
    Constructor
    \param owner
    \param pixdata must be a pixmap hard-coded data
   */
  VDKPixbuf(VDKObject* owner, const char** pixdata);
  /*!
    Destructor
   */
  virtual ~VDKPixbuf();
  /*!
    GdkPixmap* conversion
  */
  GdkPixbuf* AsGdkPixbuf() { return pixbuf; }
  /*!
    Return pixbuf width in pixel
   */
  int Width() { return w; }
  /*!
    Return pixbuf height in pixel
   */
  int Height() { return h; }
};

#endif
